/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule.impl;

import gov.va.med.fw.rule.RuleParameterNameAware;

// Java classes

// Library classes

// Framework classes

// EDB classes

/**
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public class SimpleRuleParameterNameAware implements RuleParameterNameAware {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2801501752887139722L;

	/**
	 * A name used as a variable representing this rule input a rule engine
	 * memory. This name is used to insert this rule input into a rule engine's
	 * agenda.
	 */
	private String input = null;
	private String output = null;

	/**
	 * A default constructor
	 */
	public SimpleRuleParameterNameAware() {
		super();
	}

	/**
	 * Returns a variable name of an out parameter set during the execution of a
	 * rule in a rule engine memory.
	 * 
	 * @return Returns the name.
	 */
	public String getOutputName() {
		return output;
	}

	/**
	 * Sets a variable name of an out parameter set during the execution of a
	 * rule in a rule engine memory.
	 * 
	 * @param name
	 *            the output name.
	 */
	public void setOutputName(String name) {
		this.output = name;
	}

	/**
	 * Returns a name used to insert this rule wrapper class into a rule engine
	 * memory.
	 * 
	 * @return Returns the name.
	 */
	public String getInputName() {
		return input;
	}

	/**
	 * Sets a name used to insert this rule wrapper class into a rule engine
	 * memory.
	 * 
	 * @param value
	 *            A name used as a variable name in ILOG's agenda.
	 */
	public void setInputName(String value) {
		input = value;
	}
}