/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule.impl;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.rule.Match;
import gov.va.med.fw.rule.MatchRuleService;
import gov.va.med.fw.service.AbstractComponent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * @author vhaisakatikm
 * 
 */
public class MatchRuleServiceImpl extends AbstractComponent implements MatchRuleService {

	private static final long serialVersionUID = 7005290862980382680L;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.rule.MatchRuleService#findMatchingElement(gov.va.med.fw
	 * .model.AbstractEntity, java.util.Collection)
	 */
	public <T extends AbstractEntity> T findMatchingElement(T source, Collection<T> target) {
		Validate.notNull(source, "A source to find a match must not be null");
		Validate.notNull(target,
				"A target collection in which a match is searched must not be null");

		T match = null;
		for (T element : target) {
			if (match(source, (AbstractEntity) element)) {
				match = element;
				break;
			}
		}
		return match;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.rule.MatchRuleService#match(gov.va.med.fw.model.AbstractEntity
	 * , gov.va.med.fw.model.AbstractEntity)
	 */
	public <T extends AbstractEntity> boolean match(T source, T target) {
		Validate.notNull(source, "A source must not be null");
		Validate.notNull(target, "A target must not be null");
		// match by id for AbstractKeyedEntity
		if (source instanceof AbstractKeyedEntity) {
			Long srcId = ((AbstractKeyedEntity<?>) source).getId();
			Long targetId = ((AbstractKeyedEntity<?>) target).getId();
			if ((srcId != null && targetId != null && srcId.equals(targetId))) {
				return true;
			}
		}
		// match by domain concept for others
		return source.matchesDomainConcept(target);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.rule.MatchRuleService#match(java.util.Collection,
	 * java.util.Collection)
	 */
	public <T extends AbstractEntity> List<Match<T>> match(Collection<T> source,
			Collection<T> target) {
		Validate.notNull(source, "A source must not be null");
		Validate.notNull(target, "A target must not be null");
		List<Match<T>> matchList = new ArrayList<Match<T>>();
		// Handle special cases (delete all, insert all)
		// delete all
		if (source.size() == 0 && target.size() > 0) {
			for (T element : target) {
				matchList.add(new Match<T>((T) null, element));
			}
		}
		// insert all
		else if (source.size() > 0 && target.size() == 0) {
			for (T element : source) {
				matchList.add(new Match<T>(element, (T) null));
			}
		}
		// Generic case where some are modified, added, deleted
		else {
			List<T> srcList = new ArrayList<T>(source);
			List<T> targetList = new ArrayList<T>(target);
			for (T element : srcList) {
				Match<T> match = null;
				int matchIndex = -1;
				for (int j = 0; j < targetList.size(); j++) {
					T targetEntity = targetList.get(j);
					if (match(element, targetEntity)) {
						match = new Match<T>(element, targetEntity);
						matchIndex = j;
					}
				}
				// match found
				if (match != null) {
					targetList.remove(matchIndex);
					matchList.add(match);
				}// new entity
				else {
					matchList.add(new Match<T>(element, null));
				}
			}
			// deleted entities
			for (int j = 0; j < targetList.size(); j++) {
				T targetEntity = targetList.get(j);
				matchList.add(new Match<T>(null, targetEntity));
			}
		}
		return matchList;
	}
}
