/*******************************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.fw.rule;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

import gov.va.med.fw.model.lookup.SeverityType;
import gov.va.med.fw.validation.ValidationMessages;

public interface RuleState {

	/**
	 * A constant string to represent a variable name of a rule state object in
	 * a rule engine's agenda.
	 */
	public static final String DEFAULT_PARAM_NAME = StringUtils.uncapitalize(ClassUtils
			.getShortClassName(RuleState.class));

	/**
	 * Sets a flag to indicate a rule is executed successfully. This method is
	 * for a derived rule wrapper class to call when a rule participates in a
	 * complex rule flow.
	 */
	public void setRuleExecuted(boolean flag);

	/**
	 * sets a flag to indicate if the rules are in the same session
	 * 
	 * @param flag
	 *            true if in the same session. false otherwise.
	 */
	public void setInSession(boolean flag);

	/**
	 * Returns true if a rule is executed successfully otherwise returns false.
	 * This method should be called by an action method if a rule participates
	 * in a complex rule flow.
	 * 
	 * @return True if a rule is executed successfully. false otherwise
	 */
	public boolean isRuleExecuted();

	/**
	 * Returns true if rules are in the same session </br> otherwise returns
	 * false.
	 * 
	 * @return
	 */
	public boolean isInSession();

	/**
	 * @return Returns the name.
	 */
	public String getName();

	/**
	 * @param name
	 *            The name to set.
	 */
	public void setName(String name);

	public void generateRuleException(String id, String originator) throws RuleException;

	public void generateRuleException(String id, String originator, SeverityType severity)
			throws RuleException;

	/**
	 * Throws a rule validation exceptioin if a validation mode is not
	 * exhaustive and if ServerityType is ERROR
	 * 
	 * @param id
	 *            A message id to allow a client to look up for a message
	 * @param originator
	 *            An originator
	 * @param severity
	 *            Severity level of the rule validation
	 * @param contextInfo
	 *            Context info
	 * @throws RuleException
	 *             A RuleValidationException is thrown in case of error
	 */
	public void generateRuleException(String id, String originator, SeverityType severity,
			Object contextInfo) throws RuleException;

	/**
	 * @see gov.va.med.fw.rule.RuleSession#getRuleFlowNameAware()
	 */
	public RuleFlowNameAware getRuleFlowNameAware();

	/**
	 * @see gov.va.med.fw.rule.RuleSession#getRuleParameter()
	 */
	public RuleParameter getRuleParameter();

	/**
	 * @see gov.va.med.fw.rule.RuleSession#setRuleFlowNameAware(gov.va.med.fw.rule.RuleFlowNameAware)
	 */
	public void setRuleFlowNameAware(RuleFlowNameAware ruleFlow);

	/**
	 * @see gov.va.med.fw.rule.RuleSession#setRuleParameter(gov.va.med.fw.rule.RuleParameter)
	 */
	public void setRuleParameter(RuleParameter ruleParam);

	/**
	 * @return Returns the exhaustiveMode.
	 */
	public boolean isExhaustiveMode();

	/**
	 * @param exhaustiveMode
	 *            The exhaustiveMode to set.
	 */
	public void setExhaustiveMode(boolean exhaustiveMode);

	/**
	 * @return Returns the validationMessages.
	 */
	public ValidationMessages getValidationMessages();

}