/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes

// EDB classes

/**
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public interface RuleSession extends Serializable {

	/**
	 * Returns true to connect to a rule engine to debug a fule. Otherwise,
	 * return false. A concrete class returns a default value of false.
	 * 
	 * @return True if connected to a rule engine to debug false otherwise
	 */
	public boolean isDebugEnabled();

	/**
	 * Returns a state object encapsulates information about the current state
	 * of a rule
	 * 
	 * @return RuleState A rule's state
	 */
	public RuleState getState();

	/**
	 * Sets a state object encapsulates information about the current state of a
	 * rule
	 * 
	 * @param state
	 *            A rule's state
	 */
	public void setState(RuleState state);

	/**
	 * Check if a next rule in a rule flow should be executed in case of an
	 * exception or error
	 * 
	 * @return True to continue to a next rule. False otherwise
	 */
	public boolean isContinueOnFail();

	/**
	 * Sets a flag to indicate whether a next rule in a rule flow should be
	 * executed in case of error or exception
	 * 
	 * @param flag
	 *            A flag to indicate whether to continue execution
	 */
	public void setContinueOnFail(boolean flag);

}