/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule;

// Java classes
import java.util.Map;

// Library classes

// Framework classes

// EDB classes

/**
 * Provides a generic wrapper interface to contain a list of rule parameters.
 * Each rule parameter must have a unique input and output name so that ILOG can
 * bind each rule paramter to a unique parameter name in ILOG rule engine
 * agenda.
 * 
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public interface RuleParameters extends RuleParameter {

	/**
	 * Returns a map containing rule parameters
	 * 
	 * @return Returns the parameters.
	 */
	public Map<String, RuleParameter> getRuleParameters();

	/**
	 * Returns a rule parameter class by its name
	 * 
	 * @param name
	 *            A rule parameter's input name
	 * @return A rule parameter identified by its input name
	 */
	public RuleParameter getRuleParameter(String name);

	/**
	 * A derived class must populate an internal list of </br> rule parameters
	 * with the appropriate rule data</br>
	 * 
	 * @param data
	 *            A rule data object encapsulating rule-related data
	 */
	public void initializeRuleParmeters(RuleDataAware data) throws RuleConfigurationException;

	/**
	 * A derived class must populate an internal list of </br> rule parameters
	 * with the appropriate rule data in a map
	 * 
	 * @param data
	 *            A rule data object encapsulating rule-related data
	 */
	public void initializeRuleParmeters(Map data) throws RuleConfigurationException;
}
