/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.rule;

// Java classes
import java.io.Serializable;

// Library classes

// Framework classes

// EDB classes

/**
 * Provides generic methods to set/get input and output variable name of a rule
 * parameter.
 * 
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public interface RuleParameterNameAware extends Serializable {

	public static final String DEFAULT_IN_PARAM_NAME = "in";
	public static final String DEFAULT_OUT_PARAM_NAME = "out";

	/**
	 * Returns a name used to insert this rule wrapper class into a rule engine
	 * memory.
	 * 
	 * @return Returns the name.
	 */
	public String getInputName();

	/**
	 * Sets a name used to insert this rule wrapper class into a rule engine
	 * memory.
	 * 
	 * @param name
	 *            the input name.
	 */
	public void setInputName(String name);

	/**
	 * Returns a variable name of an out parameter set during the execution of a
	 * rule in a rule engine memory.
	 * 
	 * @return Returns the name.
	 */
	public String getOutputName();

	/**
	 * Sets a variable name of an out parameter set during the execution of a
	 * rule in a rule engine memory.
	 * 
	 * @param name
	 *            the output name.
	 */
	public void setOutputName(String name);
}