package gov.va.med.fw.rule;

/**
 * RuleExceptionHandler.java TODO Need comments here Project:
 * ESR-4.0.0-Framework version: 1.0
 */
public interface RuleExceptionHandler {

	/**
	 * Log an exception thrown in a condition part of a rule
	 * 
	 * @param e
	 *            An exception to be processed
	 * @return False to indicate a rule is not processed. True otherwise
	 */
	public boolean handleConditionException(Exception e);

	/**
	 * Log an exception thrown in an action part of a rule then re-throw it
	 * 
	 * @param e
	 *            An exception to be processed
	 */
	public void handleActionException(Exception e);

	/**
	 * Log an exception thrown in an action part of a rule then re-throw it
	 * 
	 * @param e
	 *            An exception to be processed
	 */
	public void handleInternalException(Exception e);
}