/*******************************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ******************************************************************************/

// Package
package gov.va.med.fw.rule;

// java classes

/**
 * A base exception for all bueinss rule invocation errors. This exception is
 * thrown if a service failed to execute a business rule because of either a
 * user exception thrown in a rule or invalid input parameters for a rule flow
 * and a rule wrapper class
 * 
 * @author Vu Le
 * @version 1.0
 */
public class RuleException extends Exception {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6789630754747451866L;

	/**
	 * An instance of messageID
	 */
	private String messageID = null;
	/**
	 * An instance of originator
	 */
	private Object originator = null;

	/**
	 * An instance of ruleFlowName
	 */
	private String ruleFlowName = null;
	/**
	 * An instance of ruleWrappers
	 */
	private RuleParameter[] ruleWrappers = null;

	// generic bucket for contextInfo
	private Object contextInfo;

	/**
	 * Creates new <code>RuleException</code> without detail message.
	 */
	public RuleException() {
		super();
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message.
	 * 
	 * @param msg
	 *            the detail message.
	 */
	public RuleException(String msg) {
		super(msg);
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 */
	public RuleException(String msg, Throwable cause) {
		super(msg, cause);

	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a rule wrapper
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleException(String msg, Throwable cause, String ruleFlow, RuleParameter wrapper) {
		this(msg, cause, ruleFlow, new RuleParameter[] { wrapper });
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a rule wrapper
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleException(String msgID, Object originator, String ruleFlow, RuleParameter wrapper) {
		this.ruleFlowName = ruleFlow;
		this.ruleWrappers = new RuleParameter[] { wrapper };
		this.messageID = msgID;
		this.originator = originator;
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a list of rule
	 * wrappers
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleException(String msg, Throwable cause, String ruleFlow, RuleParameter[] wrappers) {
		super(msg, cause);
		this.ruleFlowName = ruleFlow;
		this.ruleWrappers = wrappers;
		this.messageID = (cause instanceof RuleValidationException) ? ((RuleValidationException) cause)
				.getMessageID()
				: null;
		this.originator = (cause instanceof RuleValidationException) ? ((RuleValidationException) cause)
				.getOriginator()
				: null;
	}

	/**
	 * @return Returns the ruleFlowName.
	 */
	public String getRuleFlowName() {
		return ruleFlowName;
	}

	/**
	 * @return Returns the ruleWrapper.
	 */
	public RuleParameter getRuleWrapper() {
		return (ruleWrappers != null && ruleWrappers.length == 1) ? ruleWrappers[0] : null;
	}

	/**
	 * @return Returns the ruleWrapper list
	 */
	public RuleParameter[] getRuleWrappers() {
		return ruleWrappers;
	}

	/**
	 * @return Returns the messageID.
	 */
	public String getMessageID() {
		return this.messageID;
	}

	/**
	 * @return Returns the originator.
	 */
	public Object getOriginator() {
		return this.originator;
	}

	/**
	 * @return Returns the contextInfo.
	 */
	public Object getContextInfo() {
		return contextInfo;
	}

	/**
	 * @param contextInfo
	 *            The contextInfo to set.
	 */
	public void setContextInfo(Object contextInfo) {
		this.contextInfo = contextInfo;
	}
}