/*****************************************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.fw.rule;

import java.util.Map;

/**
 * RuleEngine.java
 * 
 * Provideds a generic interface to execute business rules using data
 * encapsulated in a RuleParameter, and a collection of RuleParameter in a
 * RuleParameters class
 * 
 * Project: ESR-4.0.0-Framework version: 1.0
 */
public interface RuleEngine extends SimpleRuleEngine {

	/**
	 * Executes a rule set or a collection of rules specified in a set of
	 * RuleParameter
	 * 
	 * @paran param An instance of RuleParameter encapsulating an eXecution
	 *        Object Model (XOM)
	 * @param data
	 *            An instance of RuleDataAware encapsulating generic rule data
	 * @return A result object
	 * @throws RuleException
	 *             thrown in case of exceptions raised during rule execution
	 */
	public Object execute(RuleParameters params, RuleDataAware data) throws RuleException;

	/**
	 * Executes a rule set or a collection of rules specified in a set of
	 * RuleParameter
	 * 
	 * @paran param An instance of RuleParameter encapsulating an eXecution
	 *        Object Model (XOM)
	 * @param data
	 *            A map containing generic rule data
	 * @return A result object
	 * @throws RuleException
	 *             thrown in case of exceptions raised during rule execution
	 */
	public Object execute(RuleParameters params, Map data) throws RuleException;

	/**
	 * Executes a rule set or a collection of rules specified in a RuleParameter
	 * 
	 * @paran param An instance of RuleParameter encapsulating an eXecution
	 *        Object Model (XOM)
	 * @param data
	 *            An instance of RuleDataAware encapsulating generic rule data
	 * @return A result object
	 * @throws RuleException
	 *             thrown in case of exceptions raised during rule execution
	 */
	public Object execute(RuleParameter param, RuleDataAware data) throws RuleException;
}