/********************************************************************
Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.rule;

/**
 * A base exception for all bueinss rule invocations. This exception is thrown
 * if there is a problem in executing a rule due to a rule repository
 * configuration or a rule service configuration.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class RuleConfigurationException extends RuleException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5347661235517125726L;

	/**
	 * Creates new <code>RuleConfigurationException</code> without detail
	 * message.
	 */
	public RuleConfigurationException() {
		super();
	}

	/**
	 * Constructs an <code>RuleConfigurationException</code> with the specified
	 * detail message.
	 * 
	 * @param msg
	 *            the detail message.
	 */
	public RuleConfigurationException(String msg) {
		super(msg);
	}

	/**
	 * Constructs an <code>RuleConfigurationException</code> with the specified
	 * detail message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 */
	public RuleConfigurationException(String msg, Throwable cause) {
		super(msg, cause);
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a rule wrapper
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappter
	 *            a rule wrapper
	 */
	public RuleConfigurationException(String msg, Throwable cause, String ruleFlow,
			RuleParameter wrapper) {
		super(msg, cause, ruleFlow, wrapper);
	}

	/**
	 * Constructs an <code>RuleException</code> with the specified detail
	 * message, a caused exception, a rule flow name, and a rule wrapper list
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param ruleFlow
	 *            a rule flow name
	 * @param wrappters
	 *            a rule wrapper list
	 */
	public RuleConfigurationException(String msg, Throwable cause, String ruleFlow,
			RuleParameter[] wrappers) {
		super(msg, cause, ruleFlow, wrappers);
	}
}