/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport;

// Java classes
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportTemplate;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.excelreport.ExcelReport;
import gov.va.med.fw.report.excelreport.ExcelReportCell;
import gov.va.med.fw.report.excelreport.ExcelReportColumn;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.report.jasperreport.data.JasperReportDataSource;
import gov.va.med.fw.util.StringUtils;

// ESR classes

/**
 * 
 * 
 * Project: Framework</br>
 * 
 * @author vhaisakatikm
 */
public class ExcelExporter extends AbstractJasperReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8011068634784421629L;
	private static final String GROUP_LEVEL_FIELD_NAME = "glevel";
	private static final String CELL_COLUMN = "$V{COL}";
	private static final String CELL_ROW = "$V{ROW}";
	private static final String CELL_PREV_ROW = "$V{PREV_ROW}";

	/**
	 * A default constructor
	 */
	public ExcelExporter() {
		super();
	}

	@SuppressWarnings("unchecked")
	protected Object fill(ReportConfiguration config, ReportData data, ReportTemplate template)
			throws ReportException {
		try {
			JasperReport jasperReport = this.getJasperReport(config, template);
			ExcelReport excelReport = this.getExcelReport(config, template);
			if (excelReport == null)
				excelReport = new ExcelReport();

			List<ExcelReportColumn> excelReportColumns = excelReport.getColumns();
			JRField[] reportFields = jasperReport.getFields();
			JRParameter[] reportParameters = jasperReport.getParameters();
			// JRVariable[] reportVariables = jasperReport.getVariables();
			Map resourceMap = config.getResourceMapping();
			JRField glevelField = null;
			Boolean filterSummary = excelReport.getFilterSummaryRows();

			JasperReportData jasperReportData = (JasperReportData) data;
			JasperReportDataSource jrDataSource = (JasperReportDataSource) jasperReportData
					.getJasperDataSource();

			// create an excel sheet from the template
			HSSFWorkbook wb = new HSSFWorkbook();

			HSSFSheet parSheet = wb.createSheet(config.getReportName() + " Parameters");
			HSSFSheet dataSheet = wb.createSheet(config.getReportName() + " Data");
			HSSFDataFormat dataFormat = wb.createDataFormat();
			// Create Fonts
			HSSFFont fontTitle = wb.createFont();
			fontTitle.setFontName(HSSFFont.FONT_ARIAL);
			fontTitle.setFontHeightInPoints((short) 12);
			fontTitle.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

			HSSFFont fontHeader = wb.createFont();
			fontHeader.setFontName(HSSFFont.FONT_ARIAL);
			fontHeader.setFontHeightInPoints((short) 10);
			fontHeader.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
			HSSFFont fontSummary = fontHeader;

			// create global styles for headers, title
			HSSFCellStyle titleCellStyle = wb.createCellStyle();
			titleCellStyle.setFont(fontTitle);

			HSSFCellStyle headerCellStyle = wb.createCellStyle();
			headerCellStyle.setFont(fontHeader);
			//HSSFCellStyle summarCellStyle = headerCellStyle;

			// fill parameters and data
			filllTitleAndParameters(excelReport, parSheet, resourceMap, reportParameters,
					titleCellStyle);

			int rowIndex = 0;
			Object[] transferArray = new Object[4];
			transferArray[1] = wb;
			HSSFRow row = null;

			// celltype, dataformat, cellstyle (alignment..), formulae
			rowIndex = 0;
			short col = 0;

			// print header rows use the description if specified
			// fileds defined in jasper + excel fields
			HSSFCellStyle[] dataCellStyles = new HSSFCellStyle[reportFields.length
					+ excelReportColumns.size()];

			transferArray[0] = new Integer(rowIndex);
			transferArray[2] = dataSheet;
			transferArray[3] = null;
			transferArray = createRow(transferArray);
			rowIndex = ((Integer)transferArray[0]).intValue()+1;
			dataSheet = (HSSFSheet)transferArray[2];
			row = (HSSFRow)transferArray[3];
			
			List<JRField> printColumns = new ArrayList<JRField>();
			List<ExcelReportColumn> printColumnsComputed = excelReport.getColumns();

			for (JRField reportFiled : reportFields) {
				String fieldDesc = reportFiled.getDescription();
				if (GROUP_LEVEL_FIELD_NAME.equalsIgnoreCase(reportFiled.getName())) {
					// summary field
					glevelField = reportFiled;
				}
				// If the field discription is empty, it is not printed on the
				// report
				if (StringUtils.isEmpty(fieldDesc)) {
					continue; // Not a printable column
					// fieldName = reportFiled.getName();
				} else {
					// summary report columns are added based on the parameter
					// value
					Object printParValue = resourceMap.get("print_" + reportFiled.getName());
					if (printParValue == null || Boolean.TRUE.equals((Boolean) printParValue)) {
						// Add to print list
						printColumns.add(reportFiled);
					} else {
						continue;
					}
				}
				// create cell style
				HSSFCellStyle cellStyle = null;
				if (reportFiled.getValueClassName().equals("java.lang.String")) {
					cellStyle = wb.createCellStyle();
				} else if (reportFiled.getValueClassName().equals("java.util.Date")) {
					cellStyle = wb.createCellStyle();
					cellStyle.setDataFormat(dataFormat.getFormat("m/d/yyyy"));
				} else if (reportFiled.getValueClassName().equals("java.lang.Integer")) {
					cellStyle = wb.createCellStyle();
					cellStyle.setDataFormat(dataFormat.getFormat("0"));
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
				} else if (reportFiled.getValueClassName().equals("java.lang.Byte")) {
					cellStyle = wb.createCellStyle();
					cellStyle.setDataFormat(dataFormat.getFormat("0"));
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
				} else if (reportFiled.getValueClassName().equals("java.math.BigDecimal")) {
					cellStyle = wb.createCellStyle();
					cellStyle.setDataFormat(dataFormat.getFormat("0"));
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
				} else {
					// default style
					cellStyle = wb.createCellStyle();
				}
				dataCellStyles[col] = cellStyle;
				HSSFCell cell = row.createCell(col++, HSSFCell.CELL_TYPE_STRING); // add
				// format,
				// font..
				cell.setCellStyle(headerCellStyle);
				cell.setCellValue(new HSSFRichTextString(fieldDesc));
			}

			for (ExcelReportColumn excelColumn : printColumnsComputed) {
				String colHeader = excelColumn.getColumnHeader();
				HSSFCell cell = row.createCell(col, HSSFCell.CELL_TYPE_STRING);
				cell.setCellValue(new HSSFRichTextString(colHeader));
				HSSFCellStyle cellStyle = wb.createCellStyle();
				String format = excelColumn.getFormat();
				if (StringUtils.isNotEmpty(format)) {
					cellStyle.setDataFormat(dataFormat.getFormat(format));
				}
				dataCellStyles[col] = cellStyle;
				col++;
			}

			// add style for group level header as the last column
			if (glevelField != null) {
				if (filterSummary == false) {
					// create style add a header column
					HSSFCellStyle cellStyle = wb.createCellStyle();
					cellStyle.setDataFormat(dataFormat.getFormat("0"));
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
					dataCellStyles[col] = cellStyle;

					HSSFCell cell = row.createCell(col, HSSFCell.CELL_TYPE_STRING); // add
																					// format,
																					// font..
					cell.setCellValue(new HSSFRichTextString("Grouping Level"));
				}
			} else // if summary field is not defined
			{
				filterSummary = false;
			}
			// freeze the header row for the data sheet
			dataSheet.createFreezePane(0, 1, 0, 1);

			// print data set values
			while (jrDataSource.next()) {
				String summaryFieldValue = null;
				if (glevelField != null) {
					summaryFieldValue = String.valueOf(jrDataSource.getFieldValue(glevelField));
					if (!"0".equals(summaryFieldValue) && filterSummary) {
						continue; // skip summary data
					}
				}
				
				transferArray[0] = new Integer(rowIndex);
				transferArray[2] = dataSheet;
				transferArray[3] = null;
				transferArray = createRow(transferArray);
				rowIndex = ((Integer)transferArray[0]).intValue()+1;
				dataSheet = (HSSFSheet)transferArray[2];
				row = (HSSFRow)transferArray[3];
				
				
				col = 0;
				for (JRField reportFiled : printColumns) {
					Object fieldValue = jrDataSource.getFieldValue(reportFiled);
					HSSFCell cell = null;
					if (fieldValue == null) {
						cell = row.createCell(col, HSSFCell.CELL_TYPE_BLANK);
					} else if (reportFiled.getValueClassName().equals("java.lang.String")) {
						cell = row.createCell(col); // add format, font..
						cell.setCellType(HSSFCell.CELL_TYPE_STRING);
						HSSFRichTextString txt = new HSSFRichTextString(String.valueOf(fieldValue));
						cell.setCellValue(txt);
					} else if (reportFiled.getValueClassName().equals("java.util.Date")) {
						cell = row.createCell(col); // date format
						cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
						cell.setCellStyle(dataCellStyles[col]);
						Date dateValue = (Date) fieldValue;
						cell.setCellValue(dateValue);
					} else if (reportFiled.getValueClassName().equals("java.lang.Integer")) {
						cell = row.createCell(col); // number format
						cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
						cell.setCellStyle(dataCellStyles[col]);
						double doubleValue = Double.parseDouble(String.valueOf(fieldValue));
						cell.setCellValue(doubleValue);
					} else if (reportFiled.getValueClassName().equals("java.lang.Byte")) {
						cell = row.createCell(col); // number format
						cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
						cell.setCellStyle(dataCellStyles[col]);
						double doubleValue = Double.parseDouble(String.valueOf(fieldValue));
						cell.setCellValue(doubleValue);
					} else if (reportFiled.getValueClassName().equals("java.math.BigDecimal")) {
						cell = row.createCell(col); // number format
						cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
						cell.setCellStyle(dataCellStyles[col]);
						double doubleValue = Double.parseDouble(String.valueOf(fieldValue));
						cell.setCellValue(doubleValue);	
					} else if (reportFiled.getValueClassName().equals("java.lang.Double")) {
						cell = row.createCell(col); // number format
						cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
						cell.setCellStyle(dataCellStyles[col]);
						double doubleValue = Double.parseDouble(String.valueOf(fieldValue));
						cell.setCellValue(doubleValue);							
					}
					else {
						// default to string
						cell = row.createCell(col);
						cell.setCellType(HSSFCell.CELL_TYPE_STRING);
						HSSFRichTextString txt = new HSSFRichTextString(String.valueOf(fieldValue));
						cell.setCellValue(txt);
					}
					col++;
				}
				// computed excel columns
				for (ExcelReportColumn excelColumn : printColumnsComputed) {

					String formaulae = excelColumn.getFormulae();
					// String format = excelColumn.getFormat();
					if (StringUtils.isEmpty(formaulae)) {
						row.createCell(col, HSSFCell.CELL_TYPE_BLANK);
					} else {
						HSSFCell cell = row.createCell(col);
						cell.setCellType(HSSFCell.CELL_TYPE_FORMULA);
						// Update rownumber
						formaulae = formaulae.replace(CELL_ROW, String.valueOf(rowIndex));
						cell.setCellFormula(formaulae);
						cell.setCellStyle(dataCellStyles[col]);
					}
					col++;
				}
				// print the summary level (group level column)
				if (filterSummary == false && glevelField != null) //
				{
					HSSFCell cell = row.createCell(col); // number format
					cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
					cell.setCellStyle(dataCellStyles[col]);
					double doubleValue = Double.parseDouble(summaryFieldValue);
					cell.setCellValue(doubleValue);
				}
			}

			// print the report summary rows
			Map<String, ExcelReportCell> summaryRowCells = excelReport.getSummaryRowCells();

			if (summaryRowCells != null && summaryRowCells.size() > 0) {
				transferArray[0] = new Integer(rowIndex);
				transferArray[2] = dataSheet;
				transferArray[3] = null;
				transferArray = createRow(transferArray);
				rowIndex = ((Integer)transferArray[0]).intValue()+1;
				dataSheet = (HSSFSheet)transferArray[2];
				row = (HSSFRow)transferArray[3];
				
				col = 0;

				// clone the datacell styles for summary rows
				// data columns
				for (JRField reportFiled : printColumns) {
					ExcelReportCell excelReportCell = summaryRowCells.get(reportFiled.getName());
					if (excelReportCell == null) {
						row.createCell(col, HSSFCell.CELL_TYPE_BLANK);
					} else {
						HSSFCell cell = createCell(row, col, rowIndex, excelReportCell);
						HSSFCellStyle cellStyle = wb.createCellStyle();
						copyStyles(dataCellStyles[col], cellStyle);
						cellStyle.setFont(fontSummary);
						cell.setCellStyle(cellStyle);
					}
					col++;
				}
				// computed columns
				for (ExcelReportColumn excelColumn : printColumnsComputed) {
					ExcelReportCell excelReportCell = summaryRowCells.get(excelColumn
							.getColumnHeader());
					String formaulae = excelColumn.getFormulae();
					if (excelReportCell == null && StringUtils.isEmpty(formaulae)) {
						row.createCell(col, HSSFCell.CELL_TYPE_BLANK);						
					} 
					else if (excelReportCell != null) {
						HSSFCell cell = createCell(row, col, rowIndex, excelReportCell);
						HSSFCellStyle cellStyle = wb.createCellStyle();
						copyStyles(dataCellStyles[col], cellStyle);
						cellStyle.setFont(fontSummary);
						cell.setCellStyle(cellStyle);
					}else {
						HSSFCell cell = row.createCell(col);
						cell.setCellType(HSSFCell.CELL_TYPE_FORMULA);
						// Update rownumber
						formaulae = formaulae.replace(CELL_ROW, String.valueOf(rowIndex));
						cell.setCellFormula(formaulae);
						cell.setCellStyle(dataCellStyles[col]);
					}					
					col++;
				}
			}

			// Autosize columns
			autoSize(parSheet,2);
			
			//autoSize(dataSheet,printColumns.size() + printColumnsComputed.size());
			int ns = wb.getNumberOfSheets();
			for (int i=1; i<ns; i++)
			{	
				HSSFSheet currenSheet = wb.getSheetAt(i);
				autoSize(currenSheet,printColumns.size() + printColumnsComputed.size());
			}	
			
			return wb;
		} catch (Exception e) {
			throw new ReportException("Failed to populate a report ", e);
		}
	}

	private void autoSize(HSSFSheet hssfSheet, int columns){
		for (int i = 0; i < columns; i++) {
			hssfSheet.autoSizeColumn((short) i);
		}
	}
	
	@Override
	protected ByteArrayOutputStream export(Object report) throws ReportException {

		if (report instanceof JasperPrint) {
			return this.exportJasperReport((JasperPrint) report);
		} else if (report instanceof HSSFWorkbook) {
			return exportExcelReport((HSSFWorkbook) report);
		} else {
			throw new ReportException("Invalid report type to export: "
					+ report.getClass().getName());
		}
	}

	protected ByteArrayOutputStream exportExcelReport(HSSFWorkbook excelBook)
			throws ReportException {
		try {
			ByteArrayOutputStream bios = new ByteArrayOutputStream();
			excelBook.write(bios);
			return bios;
		} catch (Exception e) {
			throw new ReportException("Failed to export an excel report", e);
		}
	}

	protected ByteArrayOutputStream exportJasperReport(JasperPrint print) throws ReportException {

		try {
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			JRXlsExporter exporter = new JRXlsExporter();

			exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
			exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, output);
			exporter.setParameter(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.TRUE);

			exporter.exportReport();
			return output;
		} catch (JRException e) {
			throw new ReportException("Failed to export a reporter", e);
		}
	}

	private String format(Object parValue, String valueClassName) {
		if (valueClassName.equals("java.lang.Boolean")) {
			return ((Boolean) parValue) ? "Yes" : "No";
		} else {
			// default to string
			return String.valueOf(parValue);
		}
	}

	/**
	 * Copy style information
	 * 
	 * @param src
	 * @param dest
	 */
	private void copyStyles(HSSFCellStyle src, HSSFCellStyle dest) {
		if (src.getDataFormat() > 0)
			dest.setDataFormat(src.getDataFormat());
		if (src.getAlignment() > 0)
			dest.setAlignment(src.getAlignment());
	}

	private HSSFCell createCell(HSSFRow row, short col, int rowIndex,
			ExcelReportCell excelReportCell) {
		HSSFCell cell = row.createCell(col);
		// String
		if (StringUtils.isNotEmpty(excelReportCell.getStringValue())) {
			cell.setCellType(HSSFCell.CELL_TYPE_STRING);
			cell.setCellValue(new HSSFRichTextString(excelReportCell.getStringValue()));
		}// numeric
		else if (excelReportCell.getNumericValue() != null) {
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
			cell.setCellValue(excelReportCell.getNumericValue());
		}// formualae
		else if (StringUtils.isNotEmpty(excelReportCell.getFormulae())) {
			cell.setCellType(HSSFCell.CELL_TYPE_FORMULA);
			String formaulae = excelReportCell.getFormulae();
			formaulae = formaulae.replace(CELL_COLUMN, String.valueOf((char) (col + 65)));
			formaulae = formaulae.replace(CELL_PREV_ROW, String.valueOf(rowIndex - 1));
			formaulae = formaulae.replace(CELL_ROW, String.valueOf(rowIndex));
			cell.setCellFormula(formaulae);
		}
		return cell;
	}

	/**
	 * Add title and parameters to the excel sheet
	 * 
	 * @param excelReport
	 * @param parSheet
	 * @param resourceMap
	 * @param reportParameters
	 */
	@SuppressWarnings("unchecked")
	private void filllTitleAndParameters(ExcelReport excelReport, HSSFSheet parSheet,
			Map resourceMap, JRParameter[] reportParameters, HSSFCellStyle titleCellStyle) {
		// fill parameters and data
		int rowIndex = 0;
		HSSFRow row = null;

		// Print report title in the first row if it is defined
		if (StringUtils.isNotEmpty(excelReport.getReportTitle())) {
			String title = excelReport.getReportTitle();
			// If it contains any parameters - find and replace with parameter
			// value
			Set<String> keys = resourceMap.keySet();
			for (String pName : keys) {
				if (title.contains("$P{" + pName + "}")) {
					title = title.replace("$P{" + pName + "}", String.valueOf(resourceMap
							.get(pName)));
				}
			}

			row = parSheet.createRow(rowIndex++);
			// title parameter name
			HSSFCell titleCell = row.createCell((short) 0, HSSFCell.CELL_TYPE_STRING);
			titleCell.setCellValue(new HSSFRichTextString("Title"));
			// report title
			titleCell = row.createCell((short) 1, HSSFCell.CELL_TYPE_STRING);
			titleCell.setCellValue(new HSSFRichTextString(title));
		}

		// Print parameter values in the first sheet
		for (JRParameter reportParameter : reportParameters) {
			if (!reportParameter.isSystemDefined()) {
				// get value from the map
				Object parValue = resourceMap.get(reportParameter.getName());
				if (parValue != null) {
					// get and set value in the cell
					row = parSheet.createRow(rowIndex++);

					String valueClassName = reportParameter.getValueClassName();
					String paraName = reportParameter.getDescription();
					if (StringUtils.isEmpty(paraName)) {
						paraName = reportParameter.getName();
					}
					// parameter name cell
					HSSFCell nameCell = row.createCell((short) 0, HSSFCell.CELL_TYPE_STRING);
					nameCell.setCellValue(new HSSFRichTextString(paraName));
					// auto expand
					// parameter value cell
					HSSFCell cell = row.createCell((short) 1, HSSFCell.CELL_TYPE_STRING);
					cell.setCellValue(new HSSFRichTextString(format(parValue, valueClassName)));
					;
				}
			}
		}
		
		//Add foot notes
		for (String footer:excelReport.getFootNotes()) {
			if (footer != null) {
				row = parSheet.createRow(rowIndex++);
				// foot note cell (2nd one)
				HSSFCell nameCell = row.createCell((short) 1, HSSFCell.CELL_TYPE_STRING);
				nameCell.setCellValue(new HSSFRichTextString(footer));
			}
		}
	}
	
	//transferArray = {Integer rowIndex, HSSFWorkbook workBook, HSSFSheed dataShit, HSSFRow row}
	private Object[] createRow(Object[] transferArray) {
		int rowIndex = ((Integer)transferArray[0]).intValue();
		HSSFWorkbook wb=(HSSFWorkbook)transferArray[1];
		HSSFSheet dataSheet = (HSSFSheet)transferArray[2];
        if (rowIndex >=65536) {
           	String name = wb.getSheetName(wb.getNumberOfSheets()-1);
           	int i = name.lastIndexOf("(");
           	int j = name.lastIndexOf(")");
           	if (j==name.length()-1 && i>0) {
           		String no = name.substring(i+1, j);
           		int nn = Integer.parseInt(no)+1;
           		name = name.substring(0, i) + "(" + String.valueOf(nn) + ")";
           	} else {
           		name = name + "(1)";
           	}
            dataSheet = wb.createSheet(name);
          	rowIndex=0;
        } else {
        }
        HSSFRow row = dataSheet.createRow(rowIndex);
        transferArray[0] = new Integer(rowIndex);
        //transferArray[1] = wb;//no need, it does not change
        transferArray[2] = dataSheet;
        transferArray[3] = row;
        return transferArray;
	}
	
}
