/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.jasperreport;

// Java classes
import java.io.ByteArrayOutputStream;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;

import gov.va.med.fw.report.ReportException;

// ESR classes

/**
 * 
 * 
 * Project: Framework</br> Created on: 3:09:40 PM </br>
 * 
 * @author VHAISALEV
 */
public class CSVExporter extends AbstractJasperReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8011068634784421629L;

	/**
	 * ByteArrayOutputStream A default constructor
	 */
	public CSVExporter() {
		super();
	}

	protected ByteArrayOutputStream exportJasperReport(JasperPrint print) throws ReportException {

		try {
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			JRCsvExporter exporter = new JRCsvExporter();

			exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
			exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, output);

			exporter.exportReport();
			return output;
		} catch (JRException e) {
			throw new ReportException("Failed to export a reporter", e);
		}
	}
}