package gov.va.med.fw.report.data;

// Java classes
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

// Library classes

// Framework classes

// ESR classes

public class QueryCriteria implements Serializable {

	public static final String SUB_REPORT_NAME = "SubReport";

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5620911342173001596L;

	/**
	 * An instance of criteria
	 */
	private Map criteria = null;

	/**
	 * An instance of subReportCriteria
	 */
	private QueryCriteria subReportCriteria = null;

	/**
	 * A default constructor
	 */
	public QueryCriteria() {
		this(new HashMap());
	}

	/**
	 * A default constructor
	 */
	public QueryCriteria(Map criteria) {
		this.criteria = criteria;
	}

	/**
	 * @see gov.va.med.fw.report.data.QueryCriteria#getCriteria()
	 */
	public Map getCriteria() {
		return this.criteria;
	}

	/**
	 * @see gov.va.med.fw.report.data.QueryCriteria#addCriterion(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void addCriterion(Object name, Object value) {
		this.criteria.put(name, value);
	}

	/**
	 * @return Returns the subReportCriteria.
	 */
	public QueryCriteria getSubReportCriteria() {
		return subReportCriteria;
	}

	/**
	 * @param subReportCriteria
	 *            The subReportCriteria to set.
	 */
	public void setSubReportCriteria(QueryCriteria subReportCriteria) {
		this.subReportCriteria = subReportCriteria;
	}

	/**
	 * Sets a sub report name
	 * 
	 * @param name
	 *            A sub report name
	 */
	public void setSubReportName(String name) {
		this.addCriterion(SUB_REPORT_NAME, name);
	}

	/**
	 * Returns a sub report's name
	 * 
	 * @return A sub report's name
	 */
	public String getSubReportName() {
		Object criterion = this.getCriteria().get(SUB_REPORT_NAME);
		return criterion instanceof String ? (String) criterion : null;
	}
}