/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

// Java classes

// Library classes
import org.apache.commons.lang.Validate;

import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

// ESR classes

/**
 * 
 * 
 * Project: Framework</br> Created on: 4:27:51 PM </br>
 * 
 * @author VHAISALEV
 */
public class SynchronousReportService extends AbstractComponent implements ReportService {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3557958044224151158L;

	/**
	 * A default constructor
	 */
	public SynchronousReportService() {
		super();
	}

	/**
	 * Generates a report using the specific report configuration. Use this
	 * method to generate a report that already has a well statically defined
	 * report criteria set, and report template. A report criteria set is used
	 * to query report data to populate a report template.
	 * 
	 * @param configuration
	 *            A report configuration
	 * @return Report that encapsulates the actual formatted report
	 */
	public void buildReport(ReportConfiguration configuration) throws ServiceException {
		this.getReportBuilder(configuration).buildReport(configuration);
	}

	/**
	 * Generates a report using the specific report configuration and data
	 * 
	 * @param configuration
	 *            A report configuration
	 * @param data
	 *            Data to generate a report
	 * @return Report that encapsulates the actual formatted report
	 */
	public void buildReport(ReportConfiguration configuration, ReportData data)
			throws ServiceException {
		this.getReportBuilder(configuration).buildReport(configuration, data);
	}

	/**
	 * Returns the specific report builder that knows how to build a report A
	 * report builder is looked up in an application context using a report name
	 * as a unique ID.
	 * 
	 * @param configuration
	 *            A report configuration
	 * @return ReportBuilder a builder to build a report
	 * @throws ReportException
	 *             Thrown in case of errors obtaining a builder
	 */
	protected ReportBuilder getReportBuilder(ReportConfiguration configuration)
			throws ReportException {

		Validate.notNull(configuration, "A report configuration must not be NULL");
		Validate.notNull(configuration.getReportName(), "A report name must not be NULL");

		ReportBuilder builder = null;
		try {
			builder = (ReportBuilder) this.getComponent(configuration.getReportName(),
					ReportBuilder.class);
		} catch (Exception e) {
			if (logger.isDebugEnabled()) {
				logger.debug("A builder is not configured for report ["
						+ configuration.getReportName() + "]");
				logger.debug("Use a default builder: " + ConfigurableReportBuilder.class.getName());
			}
			logger.error("Failed to get a report builder", e);
			throw new ReportException("Failed to get a report builder", e);
		}
		return builder;
	}
}