/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

import java.io.Serializable;
import java.util.Comparator;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

/**
 * 
 * 
 * Project: Framework</br> Created on: 10:42:15 AM </br>
 * 
 * @author VHAISALEV
 */
public class ReportExportedType extends AbstractLookup {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4475659832930935535L;
	public static final Code PDF = new Code("1", "PDF");// TEMP fix
	public static final Code CSV = new Code("2", "CSV");// Revert to 1 and 2
	// after sds update
	public static final Code XLS = new Code("3", "XLS");
	public static final Code RTF = new Code("4", "RTF");
	public static final Code HTML = new Code("5", "HTML");

	private static Comparator nameComparator = new ReportExportedTypeNameComparator();

	public static Comparator getNameComparator() {
		return nameComparator;
	}

	public static class Code extends AbstractCode {

		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -5907227319716834503L;

		protected Code(String code) {
			super(code);
		}

		protected Code(String code, String alias) {
			super(code, alias);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}

	}
}

class ReportExportedTypeNameComparator implements Comparator, Serializable {

	private static final long serialVersionUID = 6562479937547812959L;

	public int compare(Object pObject1, Object pObject2) {
		String name1 = (pObject1 != null && pObject1 instanceof ReportExportedType) ? ((ReportExportedType) pObject1)
				.getName()
				: null;
		String name2 = (pObject2 != null && pObject2 instanceof ReportExportedType) ? ((ReportExportedType) pObject2)
				.getName()
				: null;
		return (name1 != null && name2 != null) ? name1.compareTo(name2) : 0;
	}
}