/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.persistent.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;

import gov.va.med.fw.model.ldap.LdapConstants;
import gov.va.med.fw.model.ldap.LdapPerson;

/**
 * Maps attributes from DirContextOperations to properties of LdapPerson.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author VHAISAANDERC
 */
public class PersonContextMapper implements ContextMapper, LdapConstants {
	private String groupOU;

	public void setGroupOU(String groupOU) {
		this.groupOU = groupOU;
	}

	public Object mapFromContext(Object ctx) {
		DirContextOperations dirContext = (DirContextOperations) ctx;
		LdapPerson person = new LdapPerson();
		person.setDn(dirContext.getStringAttribute(DISTINGUISHED_NAME));
		person.setShortDnString(dirContext.getDn().toString());
		person.setFullName(dirContext.getStringAttribute(CN));
		person.setDisplayName(dirContext.getStringAttribute(DISPLAY_NAME));
		person.setLastName(dirContext.getStringAttribute(SN));
		person.setFirstName(dirContext.getStringAttribute(GIVEN_NAME));
		person.setMiddleName(dirContext.getStringAttribute(MIDDLE_NAME));
		person.setSamAccountName(dirContext.getStringAttribute(SAM_ACCOUNT_NAME));
		person.setUserPrincipalName(dirContext.getStringAttribute(USER_PRINCIPAL));
		person.setBadPasswordCount(dirContext.getStringAttribute(BAD_PWD_COUNT));
		person.setTitle(dirContext.getStringAttribute(TITLE));
		person.setDescription(dirContext.getStringAttribute(DESCRIPTION));
		person.setDepartment(dirContext.getStringAttribute(DEPARTMENT));
		person.setOffice(dirContext.getStringAttribute(OFFICE));
		person.setTelephoneNumber(dirContext.getStringAttribute(TELEPHONE_NUMBER));
		person.setEmail(dirContext.getStringAttribute(EMAIL));

		String[] groupsArray = dirContext.getStringAttributes(MEMBER_OF);
		if (groupsArray != null) {
			List groups = Arrays.asList(groupsArray);
			List cissGroups = new ArrayList();
			List ohrsGroups = new ArrayList();
			for (Iterator i = groups.iterator(); i.hasNext();) {
				String userDn = (String) i.next();

				if (userDn.contains(OU_CISS) && userDn.contains("=" + groupOU))
					// Add only the CN portion of the distinguished name
					cissGroups.add(userDn.substring(3, userDn.indexOf(COMMA)));

			}
			person.setGroups(new TreeSet(groups));
			person.setCissGroups(new TreeSet(cissGroups));
		}
		return person;
	}
}
