/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.persistent.ldap;

import java.util.List;

import gov.va.med.fw.model.ldap.LdapGroup;
import gov.va.med.fw.model.ldap.SearchCriteria;

/**
 * Data Access Object interface for Ldap Group.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author VHAISAANDERC
 */
public interface LdapGroupDao {
	public void create(LdapGroup group);

	public void update(LdapGroup group);

	public void delete(LdapGroup group);

	public LdapGroup findByDistinguishedName(String cn);

	public List findAll();

	public LdapGroup findBySamAccountName(String sAMAccountName);

	public List find(SearchCriteria criteria);

}
