/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.persistent.hibernate;

import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;

import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.InitializingBean;

/**
 * Initial javadoc for class CurrentTimestampAction. TODO - Add content here
 * 
 * Created Aug 8, 2005 5:59:59 PM
 * 
 * @author vhaisabohmeg
 */
public class CurrentTimestampAction extends AbstractDAOAction implements InitializingBean {
	private final String CURRENT_TIMESTAMP = "ts";

	private String dialectSpecificCurrentTimestampFunction;

	private String dialectSpecificTable;

	private String sqlQuery;

	private FlushModeType flushModeType = FlushModeType.COMMIT;
	
	/**
	 * An instance of 
	 */
	public CurrentTimestampAction() {
		super();
	}

	/**
	 * @return 
	 */
	public FlushModeType getFlushModeType() {
		return flushModeType;
	}

	/**
	 * @param flushModeType
	 */
	public void setFlushModeType(FlushModeType flushModeType) {
		this.flushModeType = flushModeType;
	}

	/**
	 * @return Returns the dialectSpecificCurrentTimestampFunction.
	 */
	public String getDialectSpecificCurrentTimestampFunction() {
		return dialectSpecificCurrentTimestampFunction;
	}

	/**
	 * @param dialectSpecificCurrentTimestampFunction
	 *            The dialectSpecificCurrentTimestampFunction to set.
	 */
	public void setDialectSpecificCurrentTimestampFunction(
			String dialectSpecificCurrentTimestampFunction) {
		this.dialectSpecificCurrentTimestampFunction = dialectSpecificCurrentTimestampFunction;
	}

	/**
	 * @return Returns the dialectSpecificTable.
	 */
	public String getDialectSpecificTable() {
		return dialectSpecificTable;
	}

	/**
	 * @param dialectSpecificTable
	 *            The dialectSpecificTable to set.
	 */
	public void setDialectSpecificTable(String dialectSpecificTable) {
		this.dialectSpecificTable = dialectSpecificTable;
	}

	protected Object execute(EntityManager entityManager) {
		// let's not cause unnecessary flushing because of this query
		//FlushModeType sessionFlushMode = entityManager.getFlushMode();
		entityManager.setFlushMode(this.getFlushModeType());
		Query query = (Query) entityManager.createNativeQuery(sqlQuery);
		Object result = query.getSingleResult();
		// List results =
		// entityManager.createNativeQuery(sqlQuery).addScalar(CURRENT_TIMESTAMP,
		// Hibernate.TIMESTAMP).list();
		//entityManager.setFlushMode(sessionFlushMode);
		return result;
	}

	public void afterPropertiesSet() {
		Validate.notNull(dialectSpecificCurrentTimestampFunction);

		// initialize query
		sqlQuery = "select " + dialectSpecificCurrentTimestampFunction + " as " + CURRENT_TIMESTAMP;
		if (dialectSpecificTable != null) {
			sqlQuery = sqlQuery + " from " + dialectSpecificTable;
		}
	}
}
