/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.persistent.hibernate;

// Java Classes
import java.io.Serializable;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.SerializationUtils;

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class CloneInterceptor implements MethodInterceptor {
	public CloneInterceptor() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept
	 * .MethodInvocation)
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Object result = invocation.proceed();

		if (result instanceof Serializable) {
			return SerializationUtils.clone((Serializable) result);
		} else {
			return result;
		}
	}
}