/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model.lookup;

/**
 * Transaction type for history events. Madhu Katikala
 */
public class TransactionType extends AbstractSimpleLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6112637746499946759L;

	public static final TransactionType CODE_INSERT = new TransactionType("I");

	public static final TransactionType CODE_UPDATE = new TransactionType("U");

	public static final TransactionType CODE_DELETE = new TransactionType("D");

	/**
	 * Default Constructor
	 */
	private TransactionType(String code) {
		super(code);
	}

	public Boolean isDeleted() {
		return Boolean.valueOf(CODE_DELETE.equals(this));
	}

	public Boolean isUpdated() {
		return Boolean.valueOf(CODE_UPDATE.equals(this));
	}

	public Boolean isInserted() {
		return Boolean.valueOf(CODE_INSERT.equals(this));
	}
}
