package gov.va.med.fw.model.lookup;

import java.util.Date;
import gov.va.med.fw.model.AuditInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Muddaiah Ranga
 */
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class AbstractVersionedLookup extends AbstractLookup {

	private static final long serialVersionUID = 8255942734754635021L;

	@XmlTransient
	private boolean active = true;
	
	@XmlTransient
	private Integer sortOrder = null;
	
	// The principal that created the object.
	private AuditInfo createdBy = new AuditInfo();

	// The date/time when the object was created.
	@org.hibernate.annotations.Type(type = "gov.va.med.fw.persistent.hibernate.UTCDateType")
	private Date createdOn = null;

	// The principal that modified the object last.
	private AuditInfo modifiedBy = new AuditInfo();

	// The date/time when the object was last modified.
	@org.hibernate.annotations.Type(type = "gov.va.med.fw.persistent.hibernate.UTCDateType")
	private Date modifiedOn = null;


	/**
	 * A default constructor
	 */
	protected AbstractVersionedLookup() {
		super();
	}

	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active
	 *            the active to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	/**
	 * Returns a value that describes the relative position of the object when
	 * in a sorted collection.
	 * 
	 * @return A value that describes the relative position of the object when
	 *         in a sorted collection.
	 */
	public Integer getSortOrder() {
		return this.sortOrder;
	}

	/**
	 * Sets a value that describes the relative position of the object when in a
	 * sorted collection.
	 * 
	 * @param sortOrder
	 *            A value that describes the relative position of the object
	 *            when in a sorted collection.
	 */
	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}
	
	/**
	 * Returns the principal that created the object.
	 * 
	 * @return The principal that created the object.
	 */
	public AuditInfo getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Returns the date/time when the object was created.
	 * 
	 * @return The date/time when the object was created.
	 */
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the date/time when the object was created.
	 * 
	 * @param createdOn
	 *            The date/time when the object was created.
	 */
	private void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Returns the principal that modified the object last.
	 * 
	 * @return The principal that modified the object last.
	 */
	public AuditInfo getModifiedBy() {
		return this.modifiedBy;
	}

	/**
	 * Returns the date/time when the object was last modified.
	 * 
	 * @return The date/time when the object was last modified.
	 */
	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	/**
	 * Sets the date/time when the object was last modified.
	 * <p/>
	 * NOTE: This method should not be called directly since Hibernate will
	 * automatically call it when loading an object. However, it is public
	 * because there are certain cases when we want to build an entity manually
	 * (e.g. Building a Person with only PSIM traits for Identity Traits
	 * History).
	 * 
	 * @param modifiedOn
	 *            The date/time when the object was last modified.
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * @param createdBy
	 *            The createdBy to set.
	 */
	public void setCreatedBy(AuditInfo createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * @param modifiedBy
	 *            The modifiedBy to set.
	 */
	public void setModifiedBy(AuditInfo modifiedBy) {
		this.modifiedBy = modifiedBy;
	}


	/**
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		this.createdBy = null;
		this.modifiedBy = null;
		this.modifiedOn = null;
		this.createdOn = null;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("createdBy", this.createdBy);
		builder.append("createdOn", this.createdOn);
		builder.append("modifiedBy", this.modifiedBy);
		builder.append("modifiedOn", this.modifiedOn);
	}
}