/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.batchprocess;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.lookup.SimpleLookupUtils;

/**
 * Initial javadoc for class JobResult. TODO - Add content here
 * 
 * Created Sep 21, 2006 3:49:29 PM
 * 
 * @author VHAISABOHMEG
 */
public class JobResult extends AbstractJob<JobResult> {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = -504635301932933909L;
	private Date startDate;
	private Date endDate;
	private String context;
	private String status;
	private String statistics;
	private String jobStatus;

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("startDate", this.startDate);
		builder.append("endDate", this.endDate);
		builder.append("status", this.status);
		builder.append("context", this.context);
		builder.append("statistics", this.statistics);
	}

	/**
	 * @return Returns the context.
	 */
	public String getContext() {
		return context;
	}

	/**
	 * @param context
	 *            The context to set.
	 */
	public void setContext(String context) {
		this.context = context;
	}

	/**
	 * @return Returns the statistics.
	 */
	public String getStatistics() {
		return statistics;
	}

	/**
	 * @param statistics
	 *            The statistics to set.
	 */
	public void setStatistics(String statistics) {
		this.statistics = statistics;
	}

	/**
	 * @return Returns the status.
	 */
	public JobStatus getStatus() {
		return (JobStatus) SimpleLookupUtils.getByCode(JobStatus.class, status);
	}

	/**
	 * @param status
	 *            The status to set.
	 */
	public void setStatus(JobStatus status) {
		this.status = status.getCode();
	}

	/**
	 * @return Returns the endDate.
	 */
	public Date getEndDate() {
		return endDate;
	}

	/**
	 * @param endDate
	 *            The endDate to set.
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	/**
	 * @return Returns the startDate.
	 */
	public Date getStartDate() {
		return startDate;
	}

	/**
	 * @param startDate
	 *            The startDate to set.
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getJobStatus() {
		return jobStatus;
	}

	public void setJobStatus(String jobStatus) {
		this.jobStatus = jobStatus;
	}
}
