/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.batchprocess;

import gov.va.med.fw.security.Permission;

import java.util.HashSet;
import java.util.Set;

/**
 * Initial javadoc for class JobConfig.
 * 
 * Created Sep 21, 2006 3:47:47 PM
 * 
 * @author VHAISABOHMEG
 */
public class JobConfig extends AbstractJob<JobConfig> {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 2653206676969781752L;
	
	private Set<BatchJobPermission> internalPermisions = null;

	public Set<Permission> getPermissions() {
		// loop through and return the Permission objects
		Set<Permission> permisions = new HashSet<Permission>();
		for (BatchJobPermission bjp : getInternalPermisions())
			permisions.add(bjp.getPermission());
		return permisions;
	}

	private Set<BatchJobPermission> getInternalPermisions() {
		if (internalPermisions == null) {
			internalPermisions = new HashSet<BatchJobPermission>();
		}
		return internalPermisions;
	}
}
