/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.io;

import java.text.SimpleDateFormat;
import java.util.Date;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Default implementation that creates a dynamic file name/extension with
 * current date.
 * 
 * Created Mar 7, 2006 10:03:30 AM
 * 
 * @author VHAISABOHMEG
 */
public class DateFileNameAppender extends AbstractComponent implements FileNameAppender {
	private static String DEFAULT_DATE_FORMAT = "yyyyMMdd";
	private String appenderSeparator = "";
	private String dateFormat;
	private String postDateContent;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.io.FileNameAppender#getFileNameSuffix(java.lang.Object)
	 */
	public String getFileNameSuffix(Object obj) {
		Date target = (obj instanceof Date) ? (Date) obj : new Date();
		return appenderSeparator + (new SimpleDateFormat(dateFormat)).format(target)
				+ (postDateContent != null ? postDateContent : "");
	}

	/**
	 * @return Returns the dateFormat.
	 */
	public String getDateFormat() {
		return dateFormat;
	}

	/**
	 * @param dateFormat
	 *            The dateFormat to set.
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}

	/**
	 * @return Returns the appenderSeparator.
	 */
	public String getAppenderSeparator() {
		return appenderSeparator;
	}

	/**
	 * @param appenderSeparator
	 *            The appenderSeparator to set.
	 */
	public void setAppenderSeparator(String appenderSeparator) {
		this.appenderSeparator = appenderSeparator;
	}

	public void afterPropertiesSet() {
		if (dateFormat == null)
			dateFormat = DEFAULT_DATE_FORMAT;
	}

	/**
	 * @return Returns the postDateContent.
	 */
	public String getPostDateContent() {
		return postDateContent;
	}

	/**
	 * @param postDateContent
	 *            The postDateContent to set.
	 */
	public void setPostDateContent(String postDateContent) {
		this.postDateContent = postDateContent;
	}
}
