/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZTA segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZTA extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3913235156312265513L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZTA() {
		super();
		setName(SegmentConstants.ZTA);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZTA(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZTA(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZTA(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZTA(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS ENTER/EDIT? (.12105)
	 * 
	 * @param input
	 *            A value of TemporaryAddressIndicator
	 */
	public void setTemporaryAddressIndicator(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS ENTER/EDIT? (.12105)
	 * 
	 * @return String A value of TemporaryAddressIndicator
	 */
	public String getTemporaryAddressIndicator() {
		return getElement(1);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS START DATE (.1217) (Imprecise)
	 * 
	 * @param input
	 *            A value of TemporaryAddressStartDate
	 */
	public void setTemporaryAddressStartDate(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS START DATE (.1217) (Imprecise)
	 * 
	 * @return String A value of TemporaryAddressStartDate
	 */
	public String getTemporaryAddressStartDate() {
		return getElement(2);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS END DATE (.1218) (Imprecise)
	 * 
	 * @param input
	 *            A value of TemporaryAddressEndDate
	 */
	public void setTemporaryAddressEndDate(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS END DATE (.1218) (Imprecise)
	 * 
	 * @return String A value of TemporaryAddressEndDate
	 */
	public String getTemporaryAddressEndDate() {
		return getElement(3);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS (fields .1211-.1216)
	 * 
	 * @param input
	 *            A value of TemporaryAddress
	 */
	public void setTemporaryAddress(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS (fields .1211-.1216)
	 * 
	 * @return String A value of TemporaryAddress
	 */
	public String getTemporaryAddress() {
		return getElement(4);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS COUNTY (.12111)
	 * 
	 * @param input
	 *            A value of TemporaryAddressCounty
	 */
	public void setTemporaryAddressCounty(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * TEMPORARY ADDRESS COUNTY (.12111)
	 * 
	 * @return String A value of TemporaryAddressCounty
	 */
	public String getTemporaryAddressCounty() {
		return getElement(5);
	}

	/**
	 * 
	 * TEMPORARY PHONE NUMBER (.1219)
	 * 
	 * @param input
	 *            A value of TemporaryAddressPhoneNumber
	 */
	public void setTemporaryAddressPhoneNumber(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * TEMPORARY PHONE NUMBER (.1219)
	 * 
	 * @return String A value of TemporaryAddressPhoneNumber
	 */
	public String getTemporaryAddressPhoneNumber() {
		return getElement(6);
	}

	/**
	 * 
	 * Temp Address Date/Time Last Updated
	 * 
	 * @param input
	 *            A value of TemporaryAddressLastUpdatedDate
	 */
	public void setTemporaryAddressLastUpdatedDate(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 *Temp Address Date/Time Last Updated
	 * 
	 * @return String A value of TemporaryAddressLastUpdatedDate
	 */
	public String getTemporaryAddressLastUpdatedDate() {
		return getElement(7);
	}

	/**
	 * 
	 * Temp Address Date/Time Last Updated
	 * 
	 * @param input
	 *            A value of TemporaryAddressChangeSite
	 */
	public void setTemporaryAddressChangeSite(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * Temp Address Date/Time Last Updated
	 * 
	 * @return String A value of TemporaryAddressChangeSite
	 */
	public String getTemporaryAddressChangeSite() {
		return getElement(8);
	}
}