/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZMT segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZMT extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5617782025462136166L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZMT() {
		super();
		setName(SegmentConstants.ZMT);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMT(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMT(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMT(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMT(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential number (1= Means Test, 2 = Co-pay Test, 4=LTC Co-pay Exemption
	 * Test)
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential number (1= Means Test, 2 = Co-pay Test, 4=LTC Co-pay Exemption
	 * Test)
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * DATE OF TEST (.01) (Precise)
	 * 
	 * @param input
	 *            A value of MeansTestDate
	 */
	public void setMeansTestDate(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * DATE OF TEST (.01) (Precise)
	 * 
	 * @return String A value of MeansTestDate
	 */
	public String getMeansTestDate() {
		return getElement(1);
	}

	/**
	 * 
	 * STATUS (.03)
	 * 
	 * @param input
	 *            A value of MeansTestStatus
	 */
	public void setMeansTestStatus(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * STATUS (.03)
	 * 
	 * @return String A value of MeansTestStatus
	 */
	public String getMeansTestStatus() {
		return getElement(2);
	}

	/**
	 * 
	 * INCOME (.04)
	 * 
	 * @param input
	 *            A value of Income
	 */
	public void setIncome(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * INCOME (.04)
	 * 
	 * @return String A value of Income
	 */
	public String getIncome() {
		return getElement(3);
	}

	/**
	 * 
	 * NET WORTH (.05)
	 * 
	 * @param input
	 *            A value of NetWorth
	 */
	public void setNetWorth(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * NET WORTH (.05)
	 * 
	 * @return String A value of NetWorth
	 */
	public String getNetWorth() {
		return getElement(4);
	}

	/**
	 * 
	 * ADJUDICATION DATE/TIME (.1) (precise)
	 * 
	 * @param input
	 *            A value of AdjudicationDate
	 */
	public void setAdjudicationDate(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * ADJUDICATION DATE/TIME (.1) (precise)
	 * 
	 * @return String A value of AdjudicationDate
	 */
	public String getAdjudicationDate() {
		return getElement(5);
	}

	/**
	 * 
	 * AGREED TO PAY DEDUCTIBLE (.11)
	 * 
	 * @param input
	 *            A value of AgreedToPayDeductible
	 */
	public void setAgreedToPayDeductible(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * AGREED TO PAY DEDUCTIBLE (.11)
	 * 
	 * @return String A value of AgreedToPayDeductible
	 */
	public String getAgreedToPayDeductible() {
		return getElement(6);
	}

	/**
	 * 
	 * THRESHOLD A (.12)
	 * 
	 * @param input
	 *            A value of ThresholdA
	 */
	public void setThresholdA(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * THRESHOLD A (.12)
	 * 
	 * @return String A value of ThresholdA
	 */
	public String getThresholdA() {
		return getElement(7);
	}

	/**
	 * 
	 * DEDUCTIBLE EXPENSES (.15)
	 * 
	 * @param input
	 *            A value of DeductibleExpenses
	 */
	public void setDeductibleExpenses(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * DEDUCTIBLE EXPENSES (.15)
	 * 
	 * @return String A value of DeductibleExpenses
	 */
	public String getDeductibleExpenses() {
		return getElement(8);
	}

	/**
	 * 
	 * DATE/TIME COMPLETED (.07) (Precise)
	 * 
	 * @param input
	 *            A value of MeansTestCompletedDate
	 */
	public void setMeansTestCompletedDate(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * DATE/TIME COMPLETED (.07) (Precise)
	 * 
	 * @return String A value of MeansTestCompletedDate
	 */
	public String getMeansTestCompletedDate() {
		return getElement(9);
	}

	/**
	 * 
	 * PREVIOUS YEARS THRESHOLD (.16)
	 * 
	 * @param input
	 *            A value of PreviousYearMTThresholdFlag
	 */
	public void setPreviousYearMTThresholdFlag(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * PREVIOUS YEARS THRESHOLD (.16)
	 * 
	 * @return String A value of PreviousYearMTThresholdFlag
	 */
	public String getPreviousYearMTThresholdFlag() {
		return getElement(10);
	}

	/**
	 * 
	 * TOTAL DEPENDENTS (.18)
	 * 
	 * @param input
	 *            A value of TotalDependents
	 */
	public void setTotalDependents(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * TOTAL DEPENDENTS (.18)
	 * 
	 * @return String A value of TotalDependents
	 */
	public String getTotalDependents() {
		return getElement(11);
	}

	/**
	 * 
	 * HARDSHIP (.2)
	 * 
	 * @param input
	 *            A value of Hardship
	 */
	public void setHardship(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * HARDSHIP (.2)
	 * 
	 * @return String A value of Hardship
	 */
	public String getHardship() {
		return getElement(12);
	}

	/**
	 * 
	 * HARDSHIP REVIEW DATE (.21) (Precise)
	 * 
	 * @param input
	 *            A value of HardshipReviewDate
	 */
	public void setHardshipReviewDate(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * HARDSHIP REVIEW DATE (.21) (Precise)
	 * 
	 * @return String A value of HardshipReviewDate
	 */
	public String getHardshipReviewDate() {
		return getElement(13);
	}

	/**
	 * 
	 * DATE VETERAN SIGNED TEST (.24) (Precise)
	 * 
	 * @param input
	 *            A value of VeteranTestSignedDate
	 */
	public void setVeteranTestSignedDate(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * DATE VETERAN SIGNED TEST (.24) (Precise)
	 * 
	 * @return String A value of VeteranTestSignedDate
	 */
	public String getVeteranTestSignedDate() {
		return getElement(14);
	}

	/**
	 * 
	 * DECLINES TO GIVE INCOME INFO (.14)
	 * 
	 * @param input
	 *            A value of DeclinesToGiveIncomeInfo
	 */
	public void setDeclinesToGiveIncomeInfo(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * DECLINES TO GIVE INCOME INFO (.14)
	 * 
	 * @return String A value of DeclinesToGiveIncomeInfo
	 */
	public String getDeclinesToGiveIncomeInfo() {
		return getElement(15);
	}

	/**
	 * 
	 * TYPE OF TEST (.019) - 1 = Means Test, 2=Co-pay Test, 4=LTC Co-pay
	 * Exemption Test (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of TestType
	 */
	public void setTestType(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * TYPE OF TEST (.019) - 1 = Means Test, 2=Co-pay Test, 4=LTC Co-pay
	 * Exemption Test (VISTA Messaging HL7)
	 * 
	 * @return String A value of TestType
	 */
	public String getTestType() {
		return getElement(16);
	}

	/**
	 * 
	 * SOURCE OF TEST (.23) - 1=VAMC, 2=IVM
	 * 
	 * @param input
	 *            A value of TestSource
	 */
	public void setTestSource(String input) {
		setElement(input, 17);
	}

	/**
	 * 
	 * SOURCE OF TEST (.23) - 1=VAMC, 2=IVM
	 * 
	 * @return String A value of TestSource
	 */
	public String getTestSource() {
		return getElement(17);
	}

	/**
	 * 
	 * PRIMARY INCOME TEST FOR YEAR? (2)
	 * 
	 * @param input
	 *            A value of PrimaryTest
	 */
	public void setPrimaryTest(String input) {
		setElement(input, 18);
	}

	/**
	 * 
	 * PRIMARY INCOME TEST FOR YEAR? (2)
	 * 
	 * @return String A value of PrimaryTest
	 */
	public String getPrimaryTest() {
		return getElement(18);
	}

	/**
	 * 
	 * DATE IVM VERIFIED MEANS TEST COMPLETED (.25) (Precise)
	 * 
	 * @param input
	 *            A value of IvmVerifiedMTCompletedDate
	 */
	public void setIvmVerifiedMTCompletedDate(String input) {
		setElement(input, 19);
	}

	/**
	 * 
	 * DATE IVM VERIFIED MEANS TEST COMPLETED (.25) (Precise)
	 * 
	 * @return String A value of IvmVerifiedMTCompletedDate
	 */
	public String getIvmVerifiedMTCompletedDate() {
		return getElement(19);
	}

	/**
	 * 
	 * REFUSED TO SIGN (.26)
	 * 
	 * @param input
	 *            A value of RefusedToSign
	 */
	public void setRefusedToSign(String input) {
		setElement(input, 20);
	}

	/**
	 * 
	 * REFUSED TO SIGN (.26)
	 * 
	 * @return String A value of RefusedToSign
	 */
	public String getRefusedToSign() {
		return getElement(20);
	}

	/**
	 * 
	 * SITE CONDUCTING TEST (2.05)
	 * 
	 * @param input
	 *            A value of TestConductingSite
	 */
	public void setTestConductingSite(String input) {
		setElement(input, 21);
	}

	/**
	 * 
	 * SITE CONDUCTING TEST (2.05)
	 * 
	 * @return String A value of TestConductingSite
	 */
	public String getTestConductingSite() {
		return getElement(21);
	}

	/**
	 * 
	 * SITE GRANTING HARDSHIP (2.04)
	 * 
	 * @param input
	 *            A value of HardshipReviewSite
	 */
	public void setHardshipReviewSite(String input) {
		setElement(input, 22);
	}

	/**
	 * 
	 * SITE GRANTING HARDSHIP (2.04)
	 * 
	 * @return String A value of HardshipReviewSite
	 */
	public String getHardshipReviewSite() {
		return getElement(22);
	}

	/**
	 * 
	 * HARDSHIP EFFECTIVE DATE (2.01) (Precise)
	 * 
	 * @param input
	 *            A value of HardshipEffectiveDate
	 */
	public void setHardshipEffectiveDate(String input) {
		setElement(input, 23);
	}

	/**
	 * 
	 * HARDSHIP EFFECTIVE DATE (2.01) (Precise)
	 * 
	 * @return String A value of HardshipEffectiveDate
	 */
	public String getHardshipEffectiveDate() {
		return getElement(23);
	}

	/**
	 * 
	 * DATE/TIME TEST LAST EDITED (2.02) (Precise) (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of TestLastEditedDate
	 */
	public void setTestLastEditedDate(String input) {
		setElement(input, 24);
	}

	/**
	 * 
	 * DATE/TIME TEST LAST EDITED (2.02) (Precise) (VISTA Messaging HL7)
	 * 
	 * @return String A value of TestLastEditedDate
	 */
	public String getTestLastEditedDate() {
		return getElement(24);
	}

	/**
	 * 
	 * TEST DETERMINED STATUS (2.03) (VISTA Messaging HL7)
	 * 
	 * @param input
	 *            A value of TestDeterminedStatus
	 */
	public void setTestDeterminedStatus(String input) {
		setElement(input, 25);
	}

	/**
	 * 
	 * TEST DETERMINED STATUS (2.03) (VISTA Messaging HL7)
	 * 
	 * @return String A value of TestDeterminedStatus
	 */
	public String getTestDeterminedStatus() {
		return getElement(25);
	}

	/**
	 * 
	 * MEANS TEST SIGNED? (.29)
	 * 
	 * @param input
	 *            A value of MeansTestSignatureIndicator
	 */
	public void setMeansTestSignatureIndicator(String input) {
		setElement(input, 26);
	}

	/**
	 * 
	 * MEANS TEST SIGNED? (.29)
	 * 
	 * @return String A value of MeansTestSignatureIndicator
	 */
	public String getMeansTestSignatureIndicator() {
		return getElement(26);
	}

	/**
	 * 
	 * GMT THRESHOLD field (#.27)
	 * 
	 * @param input
	 *            A value of GmtThreshold
	 */
	public void setGmtThreshold(String input) {
		setElement(input, 27);
	}

	/**
	 * 
	 * GMT THRESHOLD field (#.27)
	 * 
	 * @return String A value of GmtThreshold
	 */
	public String getGmtThreshold() {
		return getElement(27);
	}

	/**
	 * 
	 * HARDSHIP REASON field (#2.09)
	 * 
	 * @param input
	 *            A value of HardshipReason
	 */
	public void setHardshipReason(String input) {
		setElement(input, 28);
	}

	/**
	 * 
	 * HARDSHIP REASON field (#2.09)
	 * 
	 * @return String A value of HardshipReason
	 */
	public String getHardshipReason() {
		return getElement(28);
	}

	/**
	 * VERSION - to be used with the 1010EZ project to indicate which version of
	 * the Vista means test is being edited/sent.
	 * 
	 * @param input
	 */
	public void setMeansTestVersion(String input) {
		setElement(input, 29);
	}

	/**
	 * VERSION - to be used with the 1010EZ project to indicate which version of
	 * the Vista means test is being edited/sent.
	 * 
	 * @return String Values 0-Before Feb 2005 format, 1 � Feb 2005
	 */
	public String getMeansTestVersion() {
		return getElement(29);
	}
}