/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZMH segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZMH extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6190146969093086878L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZMH() {
		super();
		setName(SegmentConstants.ZMH);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMH(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMH(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMH(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZMH(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * Varies based upon Service - (.321) or (.322) or (.52). See table below.
	 * 
	 * @param input
	 *            A value of MilitaryHistoryType
	 */
	public void setMilitaryHistoryType(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * Varies based upon Service - (.321) or (.322) or (.52). See table below.
	 * 
	 * @return String A value of MilitaryHistoryType
	 */
	public String getMilitaryHistoryType() {
		return getElement(1);
	}

	/**
	 * 
	 * Varies based upon Service - (.321) or (.322) or (.52). See table below
	 * 
	 * @param input
	 *            A value of ServiceIndicator
	 */
	public void setServiceIndicator(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * Varies based upon Service - (.321) or (.322) or (.52). See table below
	 * 
	 * @return String A value of ServiceIndicator
	 */
	public String getServiceIndicator() {
		return getElement(2);
	}

	/**
	 * 
	 * Varies based upon Service - (.321) or (.322) or (.52). See table below
	 * 
	 * @param input
	 *            A value of ServiceEntryDateAndServiceSeparationDate
	 */
	public void setServiceEntryDateAndServiceSeparationDate(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * Varies based upon Service - (.321) or (.322) or (.52). See table below
	 * 
	 * @return String A value of ServiceEntryDateAndServiceSeparationDate
	 */
	public String getServiceEntryDateAndServiceSeparationDate() {
		return getElement(3);
	}

	/**
	 * 
	 * Service Component
	 * 
	 * @param input
	 *            A value of ServiceEntryDateAndServiceSeparationDate
	 */
	public void setServiceComponent(String input) {
		setElement(input, 4);
	}

	/**
	 * ServiceComponent
	 * 
	 * @return String A value of ServiceComponent
	 */
	public String getServiceComponent() {
		return getElement(4);
	}
}