/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZIR segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZIR extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5402423998575833103L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZIR() {
		super();
		setName(SegmentConstants.ZIR);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIR(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIR(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIR(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIR(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * MARRIED LAST CALENDAR YEAR (.05)
	 * 
	 * @param input
	 *            A value of MarriedLastCalendarYear
	 */
	public void setMarriedLastCalendarYear(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * MARRIED LAST CALENDAR YEAR (.05)
	 * 
	 * @return String A value of MarriedLastCalendarYear
	 */
	public String getMarriedLastCalendarYear() {
		return getElement(1);
	}

	/**
	 * 
	 * LIVED WITH PATIENT (.06)
	 * 
	 * @param input
	 *            A value of LivedWithPatient
	 */
	public void setLivedWithPatient(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * LIVED WITH PATIENT (.06)
	 * 
	 * @return String A value of LivedWithPatient
	 */
	public String getLivedWithPatient() {
		return getElement(2);
	}

	/**
	 * 
	 * AMOUNT CONTRIBUTED TO SPOUSE (..07)
	 * 
	 * @param input
	 *            A value of AmountContributedToSpouse
	 */
	public void setAmountContributedToSpouse(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * AMOUNT CONTRIBUTED TO SPOUSE (..07)
	 * 
	 * @return String A value of AmountContributedToSpouse
	 */
	public String getAmountContributedToSpouse() {
		return getElement(3);
	}

	/**
	 * 
	 * DEPENDENT CHILDREN (.08)
	 * 
	 * @param input
	 *            A value of DependentChildren
	 */
	public void setDependentChildren(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * DEPENDENT CHILDREN (.08)
	 * 
	 * @return String A value of DependentChildren
	 */
	public String getDependentChildren() {
		return getElement(4);
	}

	/**
	 * 
	 * INCAPABLE OF SELF-SUPPORT (.09)
	 * 
	 * @param input
	 *            A value of IncapableOfSelfSupport
	 */
	public void setIncapableOfSelfSupport(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * INCAPABLE OF SELF-SUPPORT (.09)
	 * 
	 * @return String A value of IncapableOfSelfSupport
	 */
	public String getIncapableOfSelfSupport() {
		return getElement(5);
	}

	/**
	 * 
	 * CONTRIBUTED TO SUPPORT (.1)
	 * 
	 * @param input
	 *            A value of ContributedToSupport
	 */
	public void setContributedToSupport(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * CONTRIBUTED TO SUPPORT (.1)
	 * 
	 * @return String A value of ContributedToSupport
	 */
	public String getContributedToSupport() {
		return getElement(6);
	}

	/**
	 * 
	 * CHILD HAD INCOME (.11)
	 * 
	 * @param input
	 *            A value of ChildHadIncome
	 */
	public void setChildHadIncome(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * CHILD HAD INCOME (.11)
	 * 
	 * @return String A value of ChildHadIncome
	 */
	public String getChildHadIncome() {
		return getElement(7);
	}

	/**
	 * 
	 * INCOME AVAILABLE TO YOU (.12)
	 * 
	 * @param input
	 *            A value of IncomeAvailableToYou
	 */
	public void setIncomeAvailableToYou(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * INCOME AVAILABLE TO YOU (.12)
	 * 
	 * @return String A value of IncomeAvailableToYou
	 */
	public String getIncomeAvailableToYou() {
		return getElement(8);
	}

	/**
	 * 
	 * NUMBER OF DEPENDENT CHILDREN (.13)
	 * 
	 * @param input
	 *            A value of NumberOfDependentChildren
	 */
	public void setNumberOfDependentChildren(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * NUMBER OF DEPENDENT CHILDREN (.13)
	 * 
	 * @return String A value of NumberOfDependentChildren
	 */
	public String getNumberOfDependentChildren() {
		return getElement(9);
	}

	/**
	 * 
	 * Dependent Child School Indicator (Yes/No values)
	 * 
	 * @param input
	 *            A value of DependentChildSchoolIndicator
	 */
	public void setDependentChildSchoolIndicator(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * Dependent Child School Indicator (Yes/No values)
	 * 
	 * @return String A value of DependentChildSchoolIndicator
	 */
	public String getDependentChildSchoolIndicator() {
		return getElement(13);
	}
}