/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZIC segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZIC extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6180589978856991333L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZIC() {
		super();
		setName(SegmentConstants.ZIC);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIC(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIC(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIC(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIC(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * YEAR (.01) [month and date will be 0] (Imprecise)
	 * 
	 * @param input
	 *            A value of IncomeYear
	 */
	public void setIncomeYear(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * YEAR (.01) [month and date will be 0] (Imprecise)
	 * 
	 * @return String A value of IncomeYear
	 */
	public String getIncomeYear() {
		return getElement(1);
	}

	/**
	 * 
	 * SOCIAL SECURITY (NOT SSI) (.08)
	 * 
	 * @param input
	 *            A value of SocialSecurity
	 */
	public void setSocialSecurity(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * SOCIAL SECURITY (NOT SSI) (.08)
	 * 
	 * @return String A value of SocialSecurity
	 */
	public String getSocialSecurityOrGrossIncome() {
		return getElement(2);
	}

	/**
	 * 
	 * U.S. CIVIL SERVICE (.09)
	 * 
	 * @param input
	 *            A value of CivilService
	 */
	public void setCivilService(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * U.S. CIVIL SERVICE (.09)
	 * 
	 * @return String A value of CivilService
	 */
	public String getCivilService() {
		return getElement(3);
	}

	/**
	 * 
	 * U.S. RAILROAD RETIREMENT (.1)
	 * 
	 * @param input
	 *            A value of RailroadRetirement
	 */
	public void setRailroadRetirement(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * U.S. RAILROAD RETIREMENT (.1)
	 * 
	 * @return String A value of RailroadRetirement
	 */
	public String getRailroadRetirement() {
		return getElement(4);
	}

	/**
	 * 
	 * MILITARY RETIREMENT (.11)
	 * 
	 * @param input
	 *            A value of MilitaryRetirement
	 */
	public void setMilitaryRetirement(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * MILITARY RETIREMENT (.11)
	 * 
	 * @return String A value of MilitaryRetirement
	 */
	public String getMilitaryRetirement() {
		return getElement(5);
	}

	/**
	 * 
	 * UNEMPLOYMENT COMPENSATION (.12)
	 * 
	 * @param input
	 *            A value of UnemploymentCompensation
	 */
	public void setUnemploymentCompensation(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * UNEMPLOYMENT COMPENSATION (.12)
	 * 
	 * @return String A value of UnemploymentCompensation
	 */
	public String getUnemploymentCompensation() {
		return getElement(6);
	}

	/**
	 * 
	 * OTHER RETIREMENT (.13)
	 * 
	 * @param input
	 *            A value of OtherRetirement
	 */
	public void setOtherRetirement(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * OTHER RETIREMENT (.13)
	 * 
	 * @return String A value of OtherRetirement
	 */
	public String getOtherRetirement() {
		return getElement(7);
	}

	/**
	 * 
	 * TOTAL INCOME FROM EMPLOYMENT (.14)
	 * 
	 * @param input
	 *            A value of EmploymentIncome
	 */
	public void setEmploymentIncome(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * TOTAL INCOME FROM EMPLOYMENT (.14)
	 * 
	 * @return String A value of EmploymentIncome
	 */
	public String getEmploymentIncome() {
		return getElement(8);
	}

	/**
	 * 
	 * INTEREST, DIVIDEND, ANNUITY (.15)
	 * 
	 * @param input
	 *            A value of InterestDividendAnnuity
	 */
	public void setInterestDividendAnnuity(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * INTEREST, DIVIDEND, ANNUITY (.15)
	 * 
	 * @return String A value of InterestDividendAnnuity
	 */
	public String getInterestDividendAnnuity() {
		return getElement(9);
	}

	/**
	 * 
	 * WORKERS COMP. OR BLACK LUNG (.16)
	 * 
	 * @param input
	 *            A value of WorkersCompBlackLung
	 */
	public void setWorkersCompBlackLung(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * WORKERS COMP. OR BLACK LUNG (.16)
	 * 
	 * @return String A value of WorkersCompBlackLung
	 */
	public String getWorkersCompBlackLung() {
		return getElement(10);
	}

	/**
	 * 
	 * ALL OTHER INCOME (.17)
	 * 
	 * @param input
	 *            A value of OtherIncome
	 */
	public void setOtherIncome(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * ALL OTHER INCOME (.17)
	 * 
	 * @return String A value of OtherIncome
	 */
	public String getOtherIncome() {
		return getElement(11);
	}

	/**
	 * 
	 * MEDICAL EXPENSES (1.01) [veteran only]
	 * 
	 * @param input
	 *            A value of MedicalExpenses
	 */
	public void setMedicalExpenses(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * MEDICAL EXPENSES (1.01) [veteran only]
	 * 
	 * @return String A value of MedicalExpenses
	 */
	public String getMedicalExpenses() {
		return getElement(12);
	}

	/**
	 * 
	 * FUNERAL AND BURIAL EXPENSES (1.02) [veteran only]
	 * 
	 * @param input
	 *            A value of FuneralExpenses
	 */
	public void setFuneralExpenses(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * FUNERAL AND BURIAL EXPENSES (1.02) [veteran only]
	 * 
	 * @return String A value of FuneralExpenses
	 */
	public String getFuneralExpenses() {
		return getElement(13);
	}

	/**
	 * 
	 * EDUCATIONAL EXPENSES (1.03) [veteran only]
	 * 
	 * @param input
	 *            A value of EducationalExpenses
	 */
	public void setEducationalExpenses(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * EDUCATIONAL EXPENSES (1.03) [veteran only]
	 * 
	 * @return String A value of EducationalExpenses
	 */
	public String getEducationalExpenses() {
		return getElement(14);
	}

	/**
	 * 
	 * CASH,AMOUNTS IN BANK ACCOUNTS (2.01) [vet/spouse only]
	 * 
	 * @param input
	 *            A value of CashAmountInBankAccounts
	 */
	public void setCashAmountInBankAccounts(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * CASH,AMOUNTS IN BANK ACCOUNTS (2.01) [vet/spouse only]
	 * 
	 * @return String A value of CashAmountInBankAccounts
	 */
	public String getCashAmountInBankAccounts() {
		return getElement(15);
	}

	/**
	 * 
	 * STOCKS AND BONDS (2.02) [vet/spouse only]
	 * 
	 * @param input
	 *            A value of StocksAndBonds
	 */
	public void setStocksAndBonds(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * STOCKS AND BONDS (2.02) [vet/spouse only]
	 * 
	 * @return String A value of StocksAndBonds
	 */
	public String getStocksAndBonds() {
		return getElement(16);
	}

	/**
	 * 
	 * REAL PROPERTY (2.03) [vet/spouse only]
	 * 
	 * @param input
	 *            A value of RealProperty
	 */
	public void setRealProperty(String input) {
		setElement(input, 17);
	}

	/**
	 * 
	 * REAL PROPERTY (2.03) [vet/spouse only]
	 * 
	 * @return String A value of RealProperty
	 */
	public String getRealProperty() {
		return getElement(17);
	}

	/**
	 * 
	 * OTHER PROPERTY OR ASSETS (2.04) [vet/spouse only]
	 * 
	 * @param input
	 *            A value of OtherPropertyAssets
	 */
	public void setOtherPropertyAssets(String input) {
		setElement(input, 18);
	}

	/**
	 * 
	 * OTHER PROPERTY OR ASSETS (2.04) [vet/spouse only]
	 * 
	 * @return String A value of OtherPropertyAssets
	 */
	public String getOtherPropertyAssets() {
		return getElement(18);
	}

	/**
	 * 
	 * DEBTS (2.05) [vet/spouse only]
	 * 
	 * @param input
	 *            A value of Debts
	 */
	public void setDebts(String input) {
		setElement(input, 19);
	}

	/**
	 * 
	 * DEBTS (2.05) [vet/spouse only]
	 * 
	 * @return String A value of Debts
	 */
	public String getDebts() {
		return getElement(19);
	}

	/**
	 * 
	 * ENTERED ON (102) (Imprecise)
	 * 
	 * @param input
	 *            A value of IncomeScreeningCollectedDate
	 */
	public void setIncomeScreeningCollectedDate(String input) {
		setElement(input, 20);
	}

	/**
	 * 
	 * ENTERED ON (102) (Imprecise)
	 * 
	 * @return String A value of IncomeScreeningCollectedDate
	 */
	public String getIncomeScreeningCollectedDate() {
		return getElement(20);
	}

	/**
	 * 
	 * SITE CONDUCTING TEST (2.05)
	 * 
	 * @param input
	 *            A value of SiteConductingTest
	 */
	public void setSiteConductingTest(String input) {
		setElement(input, 21);
	}

	/**
	 * 
	 * SITE CONDUCTING TEST (2.05)
	 * 
	 * @return String A value of SiteConductingTest
	 */
	public String getSiteConductingTest() {
		return getElement(21);
	}

	/**
	 * 
	 * SOURCE OF TEST (.23) - 1=VAMC, 2=IVM
	 * 
	 * @param input
	 *            A value of TestSource
	 */
	public void setTestSource(String input) {
		setElement(input, 22);
	}

	/**
	 * 
	 * SOURCE OF TEST (.23) - 1=VAMC, 2=IVM
	 * 
	 * @return String A value of TestSource
	 */
	public String getTestSource() {
		return getElement(22);
	}
}