/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZEN segment containing information about VA specific enrollment process
 * 
 * @author VHAISALEV
 * @version 1.0
 */

public class ZEN extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5416989133029194069L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZEN() {
		super();
		setName(SegmentConstants.ZEN);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEN(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEN(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEN(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEN(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * ENROLLMENT DATE (.1) (PRECISE)
	 * 
	 * @param input
	 *            A value of EnrollmentDate
	 */
	public void setEnrollmentDate(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * ENROLLMENT DATE (.1) (PRECISE)
	 * 
	 * @return String A value of EnrollmentDate
	 */
	public String getEnrollmentDate() {
		return getElement(1);
	}

	/**
	 * 
	 * SOURCE OF ENROLLMENT (.03) 1 = VAMC, 2 = HEC, 3 = OTHER VAMC
	 * 
	 * 
	 * @param input
	 *            A value of EnrollmentSource
	 */
	public void setEnrollmentSource(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * SOURCE OF ENROLLMENT (.03) 1 = VAMC, 2 = HEC, 3 = OTHER VAMC
	 * 
	 * 
	 * @return String A value of EnrollmentSource
	 */
	public String getEnrollmentSource() {
		return getElement(2);
	}

	/**
	 * 
	 * ENROLLMENT STATUS (.04)
	 * 
	 * @param input
	 *            A value of EnrollmentStatus
	 */
	public void setEnrollmentStatus(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * ENROLLMENT STATUS (.04)
	 * 
	 * @return String A value of EnrollmentStatus
	 */
	public String getEnrollmentStatus() {
		return getElement(3);
	}

	/**
	 * 
	 * REASON CANCELED/DECLINED (.05)
	 * 
	 * @param input
	 *            A value of Reason
	 */
	public void setReason(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * REASON CANCELED/DECLINED (.05)
	 * 
	 * @return String A value of Reason
	 */
	public String getReason() {
		return getElement(4);
	}

	/**
	 * 
	 * CANCELED/DECLINED REMARKS (25)
	 * 
	 * @param input
	 *            A value of Remarks
	 */
	public void setRemarks(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * CANCELED/DECLINED REMARKS (25)
	 * 
	 * @return String A value of Remarks
	 */
	public String getRemarks() {
		return getElement(5);
	}

	/**
	 * 
	 * FACILITY RECEIVED (.06)
	 * 
	 * @param input
	 *            A value of FacilityReceived
	 */
	public void setFacilityReceived(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * FACILITY RECEIVED (.06)
	 * 
	 * @return String A value of FacilityReceived
	 */
	public String getFacilityReceived() {
		return getElement(6);
	}

	/**
	 * 
	 * PREFERRED FACILITY (#2) (27.02)
	 * 
	 * @param input
	 *            A value of PreferredFacility
	 */
	public void setPreferredFacility(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * PREFERRED FACILITY (#2) (27.02)
	 * 
	 * @return String A value of PreferredFacility
	 */
	public String getPreferredFacility() {
		return getElement(7);
	}

	/**
	 * 
	 * ENROLLMENT PRIORITY (.07)
	 * 
	 * @param input
	 *            A value of EnrollmentPriority
	 */
	public void setEnrollmentPriority(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * ENROLLMENT PRIORITY (.07)
	 * 
	 * @return String A value of EnrollmentPriority
	 */
	public String getEnrollmentPriority() {
		return getElement(8);
	}

	/**
	 * 
	 * EFFECTIVE DATE (.08) (PRECISE)
	 * 
	 * @param input
	 *            A value of EffectiveDate
	 */
	public void setEffectiveDate(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * EFFECTIVE DATE (.08) (PRECISE)
	 * 
	 * @return String A value of EffectiveDate
	 */
	public String getEffectiveDate() {
		return getElement(9);
	}

	/**
	 * 
	 * ENROLLMENT APPLICATION DATE (.01) (PRECISE)
	 * 
	 * @param input
	 *            A value of EnrollmentApplicationDate
	 */
	public void setEnrollmentApplicationDate(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * ENROLLMENT APPLICATION DATE (.01) (PRECISE)
	 * 
	 * @return String A value of EnrollmentApplicationDate
	 */
	public String getEnrollmentApplicationDate() {
		return getElement(10);
	}

	/**
	 * 
	 * ENROLLMENT END DATE (.11 (PRECISE)
	 * 
	 * @param input
	 *            A value of EnrollmentEndDate
	 */
	public void setEnrollmentEndDate(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * ENROLLMENT END DATE (.11 (PRECISE)
	 * 
	 * @return String A value of EnrollmentEndDate
	 */
	public String getEnrollmentEndDate() {
		return getElement(11);
	}

	/**
	 * 
	 * ENROLLMENT SUB-GROUP (.12)
	 * 
	 * @param input
	 *            A value of EnrollmentSubGroup
	 */
	public void setEnrollmentSubGroup(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * ENROLLMENT SUB-GROUP (.12)
	 * 
	 * @return String A value of EnrollmentSubGroup
	 */
	public String getEnrollmentSubGroup() {
		return getElement(12);
	}
}