/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZEM segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZEM extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1506080204725761636L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZEM() {
		super();
		setName(SegmentConstants.ZEM);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEM(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEM(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEM(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEM(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * 1 if patient, 2 if spouse
	 * 
	 * @param input
	 *            A value of EmploymentPerson
	 */
	public void setEmploymentPerson(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * 1 if patient, 2 if spouse
	 * 
	 * @return String A value of EmploymentPerson
	 */
	public String getEmploymentPerson() {
		return getElement(1);
	}

	/**
	 * 
	 * EMPLOYMENT STATUS: Patient (.31115) or Spouse (.2515)
	 * 
	 * @param input
	 *            A value of EmploymentStatus
	 */
	public void setEmploymentStatus(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * EMPLOYMENT STATUS: Patient (.31115) or Spouse (.2515)
	 * 
	 * @return String A value of EmploymentStatus
	 */
	public String getEmploymentStatus() {
		return getElement(2);
	}

	/**
	 * 
	 * EMPLOYER NAME: Patient (.3111) or Spouse (.251)
	 * 
	 * @param input
	 *            A value of EmployerName
	 */
	public void setEmployerName(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * EMPLOYER NAME: Patient (.3111) or Spouse (.251)
	 * 
	 * @return String A value of EmployerName
	 */
	public String getEmployerName() {
		return getElement(3);
	}

	/**
	 * 
	 * OCCUPATION (.07) or SPOUSE'S OCCUPATION (.2514)
	 * 
	 * @param input
	 *            A value of Occupation
	 */
	public void setOccupation(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * OCCUPATION (.07) or SPOUSE'S OCCUPATION (.2514)
	 * 
	 * @return String A value of Occupation
	 */
	public String getOccupation() {
		return getElement(4);
	}

	/**
	 * 
	 * EMPLOYER ADDRESS: Patient (.3113-.3118) or Spouse (.252-.257)
	 * 
	 * @param input
	 *            A value of EmployerAddress
	 */
	public void setEmployerAddress(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * EMPLOYER ADDRESS: Patient (.3113-.3118) or Spouse (.252-.257)
	 * 
	 * @return String A value of EmployerAddress
	 */
	public String getEmployerAddress() {
		return getElement(5);
	}

	/**
	 * 
	 * EMPLOYER PHONE NUMBER: Patient (.3119) or Spouse (.258)
	 * 
	 * @param input
	 *            A value of EmployerPhoneNumber
	 */
	public void setEmployerPhoneNumber(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * EMPLOYER PHONE NUMBER: Patient (.3119) or Spouse (.258)
	 * 
	 * @return String A value of EmployerPhoneNumber
	 */
	public String getEmployerPhoneNumber() {
		return getElement(6);
	}

	/**
	 * 
	 * GOVERNMENT AGENCY (.3112) [patient only]
	 * 
	 * @param input
	 *            A value of GovernmentAgency
	 */
	public void setGovernmentAgency(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * GOVERNMENT AGENCY (.3112) [patient only]
	 * 
	 * @return String A value of GovernmentAgency
	 */
	public String getGovernmentAgency() {
		return getElement(7);
	}
}