/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZELZ11 segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZELZ11 extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6955125644577893402L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZELZ11() {
		super();
		setName(SegmentConstants.ZELZ11);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZELZ11(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZELZ11(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZELZ11(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZELZ11(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER (1 is always primary eligibility)
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER (1 is always primary eligibility)
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * CPO_ENT_CODE
	 * 
	 * @param input
	 *            A value of EligibilityCode
	 */
	public void setEligibilityCode(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * CPO_ENT_CODE
	 * 
	 * @return String A value of EligibilityCode
	 */
	public String getEligibilityCode() {
		return getElement(1);
	}

	/**
	 * 
	 * CPO_STUB (First 5 characters of Last Name)
	 * 
	 * @param input
	 *            A value of StubName
	 */
	public void setStubName(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * CPO_STUB (First 5 characters of Last Name)
	 * 
	 * @return String A value of StubName
	 */
	public String getStubName() {
		return getElement(2);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of LongID
	 */
	public void setLongID(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of LongID
	 */
	public String getLongID() {
		return getElement(3);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ShortID
	 */
	public void setShortID(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ShortID
	 */
	public String getShortID() {
		return getElement(4);
	}

	/**
	 * 
	 * BIRLS_VETCNUM
	 * 
	 * @param input
	 *            A value of ClaimFolderNumber
	 */
	public void setClaimFolderNumber(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * BIRLS_VETCNUM
	 * 
	 * @return String A value of ClaimFolderNumber
	 */
	public String getClaimFolderNumber() {
		return getElement(5);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ClaimFolderLocation
	 */
	public void setClaimFolderLocation(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ClaimFolderLocation
	 */
	public String getClaimFolderLocation() {
		return getElement(6);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of Veteran
	 */
	public void setVeteran(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of Veteran
	 */
	public String getVeteran() {
		return getElement(7);
	}

	/**
	 * 
	 * IVM_MATCH_LEVEL
	 * 
	 * @param input
	 *            A value of PatientType
	 */
	public void setPatientType(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * IVM_MATCH_LEVEL
	 * 
	 * @return String A value of PatientType
	 */
	public String getPatientType() {
		return getElement(8);
	}

	/**
	 * 
	 * BIRLS_DIAGS_VER
	 * 
	 * @param input
	 *            A value of EligibilityStatus
	 */
	public void setEligibilityStatus(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * BIRLS_DIAGS_VER
	 * 
	 * @return String A value of EligibilityStatus
	 */
	public String getEligibilityStatus() {
		return getElement(9);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of EligibilityStatusDate
	 */
	public void setEligibilityStatusDate(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of EligibilityStatusDate
	 */
	public String getEligibilityStatusDate() {
		return getElement(10);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of EligibilityInterimResponse
	 */
	public void setEligibilityInterimResponse(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of EligibilityInterimResponse
	 */
	public String getEligibilityInterimResponse() {
		return getElement(11);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of EligibilityVerificationMethod
	 */
	public void setEligibilityVerificationMethod(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of EligibilityVerificationMethod
	 */
	public String getEligibilityVerificationMethod() {
		return getElement(12);
	}

	/**
	 * 
	 * CPO_AIDA
	 * 
	 * @param input
	 *            A value of ReceivingAABenefits
	 */
	public void setReceivingAABenefits(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * CPO_AIDA
	 * 
	 * @return String A value of ReceivingAABenefits
	 */
	public String getReceivingAABenefits() {
		return getElement(13);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ReceivingHouseboundBenefits
	 */
	public void setReceivingHouseboundBenefits(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ReceivingHouseboundBenefits
	 */
	public String getReceivingHouseboundBenefits() {
		return getElement(14);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ReceivingVaPension
	 */
	public void setReceivingVaPension(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ReceivingVaPension
	 */
	public String getReceivingVaPension() {
		return getElement(15);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ReceivingVaDisability
	 */
	public void setReceivingVaDisability(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ReceivingVaDisability
	 */
	public String getReceivingVaDisability() {
		return getElement(16);
	}

	/**
	 * 
	 * MONTHLY AMOUNT OF VA CHECK (Must Multiple Value By 12 To Determine Annual
	 * Amount) (UPDATED)
	 * 
	 * @param input
	 *            A value of AnnualVaCheckAmount
	 */
	public void setAnnualVaCheckAmount(String input) {
		setElement(input, 17);
	}

	/**
	 * 
	 * MONTHLY AMOUNT OF VA CHECK (Must Multiple Value By 12 To Determine Annual
	 * Amount) (UPDATED)
	 * 
	 * @return String A value of AnnualVaCheckAmount
	 */
	public String getAnnualVaCheckAmount() {
		return getElement(17);
	}
}