/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZEG segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZEG extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7997294764040907668L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZEG() {
		super();
		setName(SegmentConstants.ZEG);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEG(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEG(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEG(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZEG(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * EGT PRIORITY VALUE field (#1)
	 * 
	 * @param input
	 *            A value of EgtPriorityValue
	 */
	public void setEgtPriorityValue(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * EGT PRIORITY VALUE field (#1)
	 * 
	 * @return String A value of EgtPriorityValue
	 */
	public String getEgtPriorityValue() {
		return getElement(0);
	}

	/**
	 * 
	 * EFFECTIVE DATE field (#.01)
	 * 
	 * @param input
	 *            A value of EffectiveDate
	 */
	public void setEffectiveDate(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * EFFECTIVE DATE field (#.01)
	 * 
	 * @return String A value of EffectiveDate
	 */
	public String getEffectiveDate() {
		return getElement(1);
	}

	/**
	 * 
	 * EGT TYPE field (#2)
	 * 
	 * @param input
	 *            A value of EgtType
	 */
	public void setEgtType(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * EGT TYPE field (#2)
	 * 
	 * @return String A value of EgtType
	 */
	public String getEgtType() {
		return getElement(2);
	}

	/**
	 * 
	 * COMMENTS field (#4)
	 * 
	 * @param input
	 *            A value of Remarks
	 */
	public void setRemarks(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * COMMENTS field (#4)
	 * 
	 * @return String A value of Remarks
	 */
	public String getRemarks() {
		return getElement(3);
	}

	/**
	 * 
	 * DATE ENTERED field (#.03)
	 * 
	 * @param input
	 *            A value of EgtChangeDate
	 */
	public void setEgtChangeDate(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * DATE ENTERED field (#.03)
	 * 
	 * @return String A value of EgtChangeDate
	 */
	public String getEgtChangeDate() {
		return getElement(4);
	}

	/**
	 * 
	 * FEDERAL REGISTER DATE field (#3)
	 * 
	 * @param input
	 *            A value of FederalRegisterDate
	 */
	public void setFederalRegisterDate(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * FEDERAL REGISTER DATE field (#3)
	 * 
	 * @return String A value of FederalRegisterDate
	 */
	public String getFederalRegisterDate() {
		return getElement(5);
	}

	/**
	 * 
	 * PRIORITY SUB GROUP (#1.5)
	 * 
	 * @param input
	 *            A value of EnrollmentSubGroup
	 */
	public void setEnrollmentSubGroup(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * PRIORITY SUB GROUP (#1.5)
	 * 
	 * @return String A value of EnrollmentSubGroup
	 */
	public String getEnrollmentSubGroup() {
		return getElement(6);
	}
}