/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZBT segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZBT extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2470596627932426847L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZBT() {
		super();
		setName(SegmentConstants.ZBT);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZBT(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZBT(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZBT(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZBT(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * DATE CERTIFIED (.01) (Precise)
	 * 
	 * @param input
	 *            A value of CertifiedDate
	 */
	public void setCertifiedDate(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * DATE CERTIFIED (.01) (Precise)
	 * 
	 * @return String A value of CertifiedDate
	 */
	public String getCertifiedDate() {
		return getElement(1);
	}

	/**
	 * 
	 * ELIGIBLE (3)
	 * 
	 * @param input
	 *            A value of Eligible
	 */
	public void setEligible(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * ELIGIBLE (3)
	 * 
	 * @return String A value of Eligible
	 */
	public String getEligible() {
		return getElement(2);
	}

	/**
	 * 
	 * AMOUNT CERTIFIED (4)
	 * 
	 * @param input
	 *            A value of CertifiedAmount
	 */
	public void setCertifiedAmount(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * AMOUNT CERTIFIED (4)
	 * 
	 * @return String A value of CertifiedAmount
	 */
	public String getCertifiedAmount() {
		return getElement(3);
	}

	/**
	 * 
	 * MEANS TEST STATUS (A;8)
	 * 
	 * @param input
	 *            A value of MeansTestStatus
	 */
	public void setMeansTestStatus(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * MEANS TEST STATUS (A;8)
	 * 
	 * @return String A value of MeansTestStatus
	 */
	public String getMeansTestStatus() {
		return getElement(4);
	}

	/**
	 * 
	 * PRIMARY ELIG. CODE (A;9 )
	 * 
	 * @param input
	 *            A value of PrimaryEligibilityCode
	 */
	public void setPrimaryEligibilityCode(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * PRIMARY ELIG. CODE (A;9 )
	 * 
	 * @return String A value of PrimaryEligibilityCode
	 */
	public String getPrimaryEligibilityCode() {
		return getElement(5);
	}

	/**
	 * 
	 * CLAIM DATE/TIME (.01) (Precise)
	 * 
	 * @param input
	 *            A value of TravelClaimDate
	 */
	public void setTravelClaimDate(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * CLAIM DATE/TIME (.01) (Precise)
	 * 
	 * @return String A value of TravelClaimDate
	 */
	public String getTravelClaimDate() {
		return getElement(6);
	}
}