/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A PD1 segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class PD1 extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2155150291241545767L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public PD1() {
		super();
		setName(SegmentConstants.PD1);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PD1(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PD1(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PD1(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PD1(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of LivingArrangement
	 */
	public void setLivingArrangement(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of LivingArrangement
	 */
	public String getLivingArrangement() {
		return getElement(1);
	}

	/**
	 * 
	 * CIRN MASTER OF RECORD (Field 991.03) ~ ~ STATION NUMBER (File #4 Field
	 * 99)
	 * 
	 * @param input
	 *            A value of CIRN
	 */
	public void setCIRN(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * CIRN MASTER OF RECORD (Field 991.03) ~ ~ STATION NUMBER (File #4 Field
	 * 99)
	 * 
	 * @return String A value of CIRN
	 */
	public String getCIRN() {
		return getElement(2);
	}

	/**
	 * 
	 * 2 Sub-Components Pointer to entry in NEW PERSON file (#200) and Facility
	 * Number (File #389.9 Field.04) family name(ST) last name prefix(ST) given
	 * name(ST) middle initial or name(ST) suffix (e.g., JR or III)(ST) prefix
	 * (e.g., DR)(ST) degree (e.g., MD)(IS) This will always be VA200 (NEW
	 * PERSON file)
	 * 
	 * @param input
	 *            A value of PrimaryCareProvider
	 */
	public void setPrimaryCareProvider(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * 2 Sub-Components Pointer to entry in NEW PERSON file (#200) and Facility
	 * Number (File #389.9 Field.04) family name(ST) last name prefix(ST) given
	 * name(ST) middle initial or name(ST) suffix (e.g., JR or III)(ST) prefix
	 * (e.g., DR)(ST) degree (e.g., MD)(IS) This will always be VA200 (NEW
	 * PERSON file)
	 * 
	 * @return String A value of PrimaryCareProvider
	 */
	public String getPrimaryCareProvider() {
		return getElement(3);
	}
}