/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A OBX segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class OBX extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3037790963634089312L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public OBX() {
		super();
		setName(SegmentConstants.OBX);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public OBX(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public OBX(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public OBX(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public OBX(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * CE
	 * 
	 * @param input
	 *            A value of ValueType
	 */
	public void setValueType(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * CE
	 * 
	 * @return String A value of ValueType
	 */
	public String getValueType() {
		return getElement(1);
	}

	/**
	 * 
	 * VISTA~28.11
	 * 
	 * @param input
	 *            A value of ObservationID
	 */
	public void setObservationID(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * VISTA~28.11
	 * 
	 * @return String A value of ObservationID
	 */
	public String getObservationID() {
		return getElement(2);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ObservationSubID
	 */
	public void setObservationSubID(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ObservationSubID
	 */
	public String getObservationSubID() {
		return getElement(3);
	}

	/**
	 * 
	 * NOTE: This will be a repeating field. identifier(ST)~text(ST)~name of
	 * coding system(ST)|identifier #2(ST)~text #2(ST)~name of coding system
	 * #2(ST)|etc�
	 * 
	 * @param input
	 *            A value of ObservationValue
	 */
	public void setObservationValue(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * NOTE: This will be a repeating field. identifier(ST)~text(ST)~name of
	 * coding system(ST)|identifier #2(ST)~text #2(ST)~name of coding system
	 * #2(ST)|etc�
	 * 
	 * @return String A value of ObservationValue
	 */
	public String getObservationValue() {
		return getElement(4);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of Units
	 */
	public void setUnits(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of Units
	 */
	public String getUnits() {
		return getElement(5);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of ReferenceRanges
	 */
	public void setReferenceRanges(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of ReferenceRanges
	 */
	public String getReferenceRanges() {
		return getElement(6);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of AbnormalFlags
	 */
	public void setAbnormalFlags(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of AbnormalFlags
	 */
	public String getAbnormalFlags() {
		return getElement(7);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of Probability
	 */
	public void setProbability(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of Probability
	 */
	public String getProbability() {
		return getElement(8);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of NatureOfAbnormalTest
	 */
	public void setNatureOfAbnormalTest(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of NatureOfAbnormalTest
	 */
	public String getNatureOfAbnormalTest() {
		return getElement(9);
	}

	/**
	 * 
	 * F (Final Results)
	 * 
	 * @param input
	 *            A value of ObservationResultStatus
	 */
	public void setObservationResultStatus(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * F (Final Results)
	 * 
	 * @return String A value of ObservationResultStatus
	 */
	public String getObservationResultStatus() {
		return getElement(10);
	}

	/**
	 * 
	 * Diagnosed With Head and Neck Cancer Date/Time (Precise)
	 * 
	 * @param input
	 *            A value of LastObservationNormalValueDate
	 */
	public void setLastObservationNormalValueDate(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * Diagnosed With Head and Neck Cancer Date/Time (Precise)
	 * 
	 * @return String A value of LastObservationNormalValueDate
	 */
	public String getLastObservationNormalValueDate() {
		return getElement(11);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of UserDefinedAccessChecks
	 */
	public void setUserDefinedAccessChecks(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of UserDefinedAccessChecks
	 */
	public String getUserDefinedAccessChecks() {
		return getElement(12);
	}

	/**
	 * 
	 * Verification Method Date/Time
	 * 
	 * @param input
	 *            A value of ObservationDate
	 */
	public void setObservationDate(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * Verification Method Date/Time
	 * 
	 * @return String A value of ObservationDate
	 */
	public String getObservationDate() {
		return getElement(13);
	}

	/**
	 * 
	 * Station Number of Site Reporting Verification Method Status
	 * 
	 * @param input
	 *            A value of ProducerID
	 */
	public void setProducerID(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * Station Number of Site Reporting Verification Method Status
	 * 
	 * @return String A value of ProducerID
	 */
	public String getProducerID() {
		return getElement(14);
	}

	/**
	 * 
	 * Component #14, Sub-Component #2 - Station Number of Site Reporting
	 * Diagnosed With Head and Neck Cancer Status
	 * 
	 * @param input
	 *            A value of ResponsibleObserver
	 */
	public void setResponsibleObserver(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * Component #14, Sub-Component #2 - Station Number of Site Reporting
	 * Diagnosed With Head and Neck Cancer Status
	 * 
	 * @return String A value of ResponsibleObserver
	 */
	public String getResponsibleObserver() {
		return getElement(15);
	}

	/**
	 * 
	 * Verification Method: S (Quality Military Service), M (Military Med
	 * Record), N (Not Qualified)
	 * 
	 * @param input
	 *            A value of ObservationMethod
	 */
	public void setObservationMethod(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * Verification Method: S (Quality Military Service), M (Military Med
	 * Record), N (Not Qualified)
	 * 
	 * @return String A value of ObservationMethod
	 */
	public String getObservationMethod() {
		return getElement(16);
	}
}