/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A MSA segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class MSA extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3173205970442125708L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public MSA() {
		super();
		setName(SegmentConstants.MSA);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public MSA(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public MSA(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public MSA(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public MSA(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * REFER TO TABLE 0008
	 * 
	 * @param input
	 *            A value of AcknowledgementCode
	 */
	public void setAcknowledgementCode(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * REFER TO TABLE 0008
	 * 
	 * @return String A value of AcknowledgementCode
	 */
	public String getAcknowledgementCode() {
		return getElement(0);
	}

	/**
	 * 
	 * MESSAGE CONTROL ID OF MESSAGE BEING ACKNOWLEDGED
	 * 
	 * @param input
	 *            A value of MessageControlID
	 */
	public void setMessageControlID(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * MESSAGE CONTROL ID OF MESSAGE BEING ACKNOWLEDGED
	 * 
	 * @return String A value of MessageControlID
	 */
	public String getMessageControlID() {
		return getElement(1);
	}

	/**
	 * 
	 * ERROR TEXT DENOTING WHY THE MESSAGE WAS REJECTED
	 * 
	 * @param input
	 *            A value of TextMessage
	 */
	public void setTextMessage(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * ERROR TEXT DENOTING WHY THE MESSAGE WAS REJECTED
	 * 
	 * @return String A value of TextMessage
	 */
	public String getTextMessage() {
		return getElement(2);
	}
}