/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.builder;

// Java classes
import java.io.Serializable;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.model.AbstractEntity;

/**
 * @author VHAISALEV
 * @version 1.0
 */
public interface MetaData extends Serializable {

	/**
	 * Return a business object
	 * 
	 * @return An entity representing a business object
	 */
	public AbstractEntity getEntity();

	/**
	 * Returns a HL7 message
	 * 
	 * @return A HL7 message
	 */
	public Message getMessage();

	/**
	 * Returns a raw data
	 * 
	 * @return
	 */
	public Object getData();
}