/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7;

import java.util.List;

import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZEN;
import gov.va.med.fw.hl7.segment.ZIE;
import gov.va.med.fw.hl7.segment.ZIO;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;

/**
 * HL7SegmentParser created on Jul 26, 2006
 * 
 * @author VHAISALEV
 */
public class HL7SegmentParser {

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static PID getPIDSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.PID) : null;
		return s instanceof PID ? (PID) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static ZPD getZPDSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.ZPD) : null;
		return s instanceof ZPD ? (ZPD) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static ZEN getZENSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.ZEN) : null;
		return s instanceof ZEN ? (ZEN) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static ZEL getZELSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.ZEL) : null;
		return s instanceof ZEL ? (ZEL) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static MSH getMSHSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.MSH) : null;
		return s instanceof MSH ? (MSH) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static MSA getMSASegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.MSA) : null;
		return s instanceof MSA ? (MSA) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static ZIO getZIOSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.ZIO) : null;
		return s instanceof ZIO ? (ZIO) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static ZSP getZSPSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.ZSP) : null;
		return s instanceof ZSP ? (ZSP) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static ZIE getZIESegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.ZIE) : null;
		return s instanceof ZIE ? (ZIE) s : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static List getZMHSegments(Message message) throws InvalidMessageException {
		return message != null ? message.getSegments(SegmentConstants.ZMH) : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static List getZEMSegments(Message message) throws InvalidMessageException {
		return message != null ? message.getSegments(SegmentConstants.ZEM) : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static List getZRDSegments(Message message) throws InvalidMessageException {
		return message != null ? message.getSegments(SegmentConstants.ZRD) : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getAcknowledgmentCode(Message message) throws InvalidMessageException {
		MSA segment = HL7SegmentParser.getMSASegment(message);
		return segment != null ? segment.getAcknowledgementCode() : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getAcknowledgmentTextMessage(Message message)
			throws InvalidMessageException {
		MSA segment = HL7SegmentParser.getMSASegment(message);
		return segment != null ? segment.getTextMessage() : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static BHS getBHSSegment(Message message) throws InvalidMessageException {
		Segment s = message != null ? message.getSegment(SegmentConstants.BHS) : null;
		return s instanceof BHS ? (BHS) s : null;
	}

}