/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7;

// Framework classes
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZSP;

/**
 * HL7MessageUtils created on Jul 27, 2006
 * 
 * @author VHAISALEV
 */
public class HL7MessageUtils extends HL7SegmentParser {

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getUnsolicitedType(Message message) throws InvalidMessageException {
		MSH msh = HL7SegmentParser.getMSHSegment(message);
		return (msh != null) ? msh.getSendingApplication() : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static Integer getCombinedPercentage(Message message) throws InvalidMessageException {

		ZSP zsp = HL7SegmentParser.getZSPSegment(message);
		return ((zsp == null) || (zsp.getServiceConnectedPercentage() == null)) ? null
				: new Integer(zsp.getServiceConnectedPercentage());
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getEntitlementCode(Message message) throws InvalidMessageException {
		ZEL zel = HL7SegmentParser.getZELSegment(message);
		return (zel != null) ? zel.getEligibilityCode() : null;
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getErrorText(Message message) throws InvalidMessageException {
		MSA msa = HL7SegmentParser.getMSASegment(message);
		return msa != null ? msa.getTextMessage() : null;
	}

	/**
	 * Strips the data and returns the Error Message
	 * 
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getErrorMessage(Message message) throws InvalidMessageException {
		MSA msa = HL7SegmentParser.getMSASegment(message);
		String errorMessage = msa != null ? msa.getTextMessage() : null;
		if (errorMessage != null) {
			if (errorMessage.indexOf("-") > 0) {
				errorMessage = errorMessage.substring(0, errorMessage.indexOf("-"));
			}
			return errorMessage.trim().toUpperCase();
		}
		return "";
	}

	/**
	 * @param message
	 * @return
	 * @throws InvalidMessageException
	 */
	public static String getMessageID(Message message) throws InvalidMessageException {
		MSA msa = HL7SegmentParser.getMSASegment(message);
		return msa != null ? msa.getMessageControlID() : null;
	}

	public static String getTransmissionDate(Message message) throws InvalidMessageException {

		String date = null;
		if (message instanceof BatchMessage) {
			BHS bhs = HL7SegmentParser.getBHSSegment(message);
			date = bhs != null ? bhs.getCreationDate() : null;
		} else {
			MSH msh = HL7SegmentParser.getMSHSegment(message);
			date = msh != null ? msh.getCreationDate() : null;
		}
		return date;
	}

	public static boolean isAck(Message message) throws InvalidMessageException {
		boolean isAck = message.getMessageType().equals("ACK");
		// one more check.....AE could have ACK in BHS (not MSH)
		if (!isAck && message.getSegment("BHS") != null) {
			String nameIDType = ((BHS) message.getSegment("BHS")).getNameIDType();
			isAck = nameIDType != null && nameIDType.indexOf("ACK") > -1;
		}
		return isAck;
	}
}