/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.hl7;

// Java classes
import java.util.List;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZEN;
import gov.va.med.fw.hl7.segment.ZIE;
import gov.va.med.fw.hl7.segment.ZIO;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;

// ESR classes

/**
 * Provides methods to access HL7 segment directly
 * 
 * Project: Framework</br> Created on: 2:09:16 PM </br>
 * 
 * @author VHAISALEV
 */
public class HL7Message extends Message {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7608890089088074678L;

	/**
	 * A default constructor
	 */
	public HL7Message(Message message) {
		Validate.notNull(message, "An HL7 message must not be null");
		this.setMessageData(message.getMessageData());
		this.setType(message.getType());
	}

	/**
	 * A default constructor
	 * 
	 * @param data
	 * @throws InvalidMessageException
	 */
	public HL7Message(String data) throws InvalidMessageException {
		super(data);
	}

	/**
	 * A default constructor
	 * 
	 * @param data
	 * @param type
	 * @throws InvalidMessageException
	 */
	public HL7Message(String data, String type) throws InvalidMessageException {
		super(data, type);
	}

	/**
	 * A default constructor
	 * 
	 * @param segments
	 * @throws InvalidMessageException
	 */
	public HL7Message(List segments) throws InvalidMessageException {
		super(segments);
	}

	/**
	 * A default constructor
	 * 
	 * @param segments
	 * @param type
	 * @throws InvalidMessageException
	 */
	public HL7Message(List segments, String type) throws InvalidMessageException {
		super(segments, type);
	}

	/**
	 * @see gov.va.med.fw.hl7.HL7SegmentAware#getPIDSegment()
	 */
	public PID getPIDSegment() throws InvalidMessageException {
		return HL7SegmentParser.getPIDSegment(this);
	}

	/**
	 * @see gov.va.med.fw.hl7.HL7SegmentAware#getZPDSegment()
	 */
	public ZPD getZPDSegment() throws InvalidMessageException {
		return HL7SegmentParser.getZPDSegment(this);
	}

	public ZEN getZENSegment() throws InvalidMessageException {
		return HL7SegmentParser.getZENSegment(this);
	}

	public ZEL getZELSegment() throws InvalidMessageException {
		return HL7SegmentParser.getZELSegment(this);
	}

	public MSH getMSHSegment() throws InvalidMessageException {
		return HL7SegmentParser.getMSHSegment(this);
	}

	public MSA getMSASegment() throws InvalidMessageException {
		return HL7SegmentParser.getMSASegment(this);
	}

	public ZIO getZIOSegment() throws InvalidMessageException {
		return HL7SegmentParser.getZIOSegment(this);
	}

	public ZSP getZSPSegment() throws InvalidMessageException {
		return HL7SegmentParser.getZSPSegment(this);
	}

	public ZIE getZIESegment() throws InvalidMessageException {
		return HL7SegmentParser.getZIESegment(this);
	}

	public List getZMHSegments() throws InvalidMessageException {
		return HL7SegmentParser.getZMHSegments(this);
	}

	public List getZEMSegments() throws InvalidMessageException {
		return HL7SegmentParser.getZEMSegments(this);
	}

	public List getZRDSegments() throws InvalidMessageException {
		return HL7SegmentParser.getZRDSegments(this);
	}

	public String getAcknowledgmentCode() throws InvalidMessageException {
		return HL7SegmentParser.getAcknowledgmentCode(this);
	}

	public String getAcknowledgmentTextMessage() throws InvalidMessageException {
		return HL7SegmentParser.getAcknowledgmentTextMessage(this);
	}

	public BHS getBHSSegment() throws InvalidMessageException {
		return HL7SegmentParser.getBHSSegment(this);
	}
}