/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.cache;

import java.sql.Timestamp;

/**
 * Initial javadoc for class TransactionTimestampCacheManager. TODO - Add
 * content here
 * 
 * Created Nov 3, 2005 2:46:25 PM
 * 
 * @author VHAISABOHMEG
 */
public class TransactionTimestampCacheManager extends AbstractCacheManager {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6836854633959773154L;

	private static final String TRANSACTION_TIMESTAMP = TransactionTimestampCacheManager.class
			.getName()
			+ ".ts";

	/**
	 * A default constructor
	 */
	public TransactionTimestampCacheManager() {
		super();
	}

	/**
	 * @param ts
	 */
	public void storeTransactionTimestamp(Timestamp ts) {
		cacheItem(TRANSACTION_TIMESTAMP, ts);
	}

	/**
	 * @return
	 */
	public Timestamp getTransactionTimestamp() {
		return (Timestamp) getItem(TRANSACTION_TIMESTAMP);
	}

	/**
	 * @return
	 */
	public boolean hasTimestamp() {
		return containsItem(TRANSACTION_TIMESTAMP);
	}

	/**
	 * @return
	 */
	public Timestamp removeTimestamp() {
		return (Timestamp) removeItem(TRANSACTION_TIMESTAMP);
	}
}