/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.batchprocess;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.hibernate.HibernateException;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.JpaTemplate;

import gov.va.med.fw.report.data.ReportDataException;

/**
 * 
 * 
 * CISS ciss_framework Nov 19, 2008
 * 
 * @author vhaisakatikm
 */
public class StoredProcedureExecutor extends AbstractTasklet {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.springframework.batch.core.step.tasklet.Tasklet#execute()
	 */
	private String queryName;
	JpaTemplate jpaTemplate;

	public JpaTemplate getJpaTemplate() {
		return jpaTemplate;
	}

	public void setJpaTemplate(JpaTemplate jpaTemplate) {
		this.jpaTemplate = jpaTemplate;
	}

	public String getQueryName() {
		return queryName;
	}

	public void setQueryName(String queryName) {
		this.queryName = queryName;
	}

	@SuppressWarnings("unchecked")
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext)
			throws Exception {
		JpaCallback callback = new JpaCallback() {
			public Object doInJpa(EntityManager entityManager) {

				List results;
				try {
					Query query = entityManager.createNamedQuery(queryName);
					results = query.getResultList();
					System.out.println(results == null ? "result is null " : results.toString());
				} catch (Exception e) {
					throw new HibernateException(e.getMessage(), e);
				}
				return results;
			}
		};

		//List results = null;
		try {
			JpaTemplate tpl = this.getJpaTemplate();
			//results = 
			tpl.executeFind(callback);
		} catch (DataAccessException e) {
			throw new ReportDataException("Failed to execute a query to retrieve report data", e);
		}		
		return RepeatStatus.FINISHED;
	}
}
