/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.AbstractComponent;

/**
 * Simple implementation of DataProcessCompletedHandler that will write
 * exception data to a file. Optionally also writes the non-exception
 * (successfully processed) data to a file.
 * 
 * Created Feb 16, 2006 7:03:52 PM
 * 
 * @author VHAISABOHMEG
 */
public class SimpleDataProcessCompletedHandler extends AbstractComponent implements
		DataProcessCompletedHandler {
	private FormattedFileWriter exceptionFileWriter;
	private FormattedFileWriter nonExceptionFileWriter;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.batchprocess.DataProcessCompletedHandler#dataProcessingComplete
	 * (gov.va.med.fw.batchprocess.DataProcessExecutionContext)
	 */
	public void dataProcessingComplete(DataProcessExecutionContext context) {
		if (!context.getExceptionData().isEmpty())
			exceptionFileWriter.writeData(context.getExceptionData());

		if (nonExceptionFileWriter != null && !context.getProcessedData().isEmpty())
			nonExceptionFileWriter.writeData(context.getProcessedData());
	}

	/**
	 * @return Returns the exceptionFileWriter.
	 */
	public FormattedFileWriter getExceptionFileWriter() {
		return exceptionFileWriter;
	}

	/**
	 * @param exceptionFileWriter
	 *            The exceptionFileWriter to set.
	 */
	public void setExceptionFileWriter(FormattedFileWriter exceptionFileWriter) {
		this.exceptionFileWriter = exceptionFileWriter;
	}

	public void afterPropertiesSet() {
		Validate.notNull(exceptionFileWriter, "exceptionFileWriter is needed");
	}

	/**
	 * @return Returns the nonExceptionFileWriter.
	 */
	public FormattedFileWriter getNonExceptionFileWriter() {
		return nonExceptionFileWriter;
	}

	/**
	 * @param nonExceptionFileWriter
	 *            The nonExceptionFileWriter to set.
	 */
	public void setNonExceptionFileWriter(FormattedFileWriter nonExceptionFileWriter) {
		this.nonExceptionFileWriter = nonExceptionFileWriter;
	}

}
