/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.io.File;
import java.util.List;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.AbstractComponent;

/**
 * DataProcessCompletedHandler implementation that writes exception data to a
 * file.
 * 
 * Created Mar 15, 2006 10:52:53 AM
 * 
 * @author VHAISABOHMEG
 */
public class ExceptionWriterProcessCompletedHandler extends AbstractComponent implements
		DataProcessCompletedHandler {
	private FormattedFileWriter fileWriter;
	private boolean deleteInputFile = true;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.batchprocess.DataProcessCompletedHandler#dataProcessingComplete
	 * (gov.va.med.fw.batchprocess.DataProcessExecutionContext)
	 */
	public void dataProcessingComplete(DataProcessExecutionContext context) {
		// write exception data
		writeExceptionData(context);
		// delete input file (if any)
		if (context instanceof DataFileProcessExecutionContext) {
			File inputFile = ((DataFileProcessExecutionContext) context).getCurrentFile();
			if (deleteInputFile && !inputFile.delete())
				throw new IllegalStateException("Unable to delete input file: "
						+ inputFile.getName());
		}
	}

	protected final void writeExceptionData(DataProcessExecutionContext context) {
		List exceptionData = getInterestedExceptionData(context);
		if (exceptionData != null && !exceptionData.isEmpty())
			fileWriter.writeData(exceptionData, getExceptionFileNameSuffixData(context));
	}

	// subclasses can override for subset of exception data to write to file
	protected List getInterestedExceptionData(DataProcessExecutionContext context) {
		return context.getExceptionData();
	}

	// subclasses can override
	protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
		return null;
	}

	/**
	 * @return Returns the fileWriter.
	 */
	public FormattedFileWriter getFileWriter() {
		return fileWriter;
	}

	/**
	 * @param fileWriter
	 *            The fileWriter to set.
	 */
	public void setFileWriter(FormattedFileWriter fileWriter) {
		this.fileWriter = fileWriter;
	}

	public void afterPropertiesSet() {
		Validate.notNull(fileWriter);
	}

	/**
	 * @return Returns the deleteInputFile.
	 */
	public boolean isDeleteInputFile() {
		return deleteInputFile;
	}

	/**
	 * @param deleteInputFile
	 *            The deleteInputFile to set.
	 */
	public void setDeleteInputFile(boolean deleteInputFile) {
		this.deleteInputFile = deleteInputFile;
	}
}
