/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.util.List;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.persistent.DAOOperations;

/**
 * Concrete class for bulk updating data based on a query update.
 * 
 * Created Mar 8, 2006 10:46:20 PM
 * 
 * @author VHAISABOHMEG
 */
public class BulkUpdateQueryProcess extends AbstractDataProcess {
	private String queryString;
	private DAOOperations dao;

	protected final void executeProcess(DataProcessExecutionContext context) throws Exception {
		Object[] queryParams = getQueryParameters(context);
		int updateCount = 0;
		if (queryParams == null)
			updateCount = getDao().bulkUpdate(getQueryString());
		else
			updateCount = getDao().bulkUpdate(getQueryString(), queryParams);
		context.getProcessStatistics().setNumberOfSuccessfulRecords(updateCount);
		context.getProcessStatistics().setNumberOfTotalRecords(updateCount);
		if (logger.isInfoEnabled())
			logger.info("BulkUpdateQueryProcess updated " + updateCount + " data records");
	}

	// can be overriden by subclasses
	protected Object[] getQueryParameters(DataProcessExecutionContext context) {
		Object executionArgs = context.getExecutionArguments();
		Object[] parameters = null;
		if (executionArgs != null) {
			if (executionArgs instanceof Object[])
				parameters = (Object[]) executionArgs;
			else
				parameters = new Object[] { executionArgs };
		}
		return parameters;
	}

	public void afterPropertiesSet() {
		super.afterPropertiesSet();
		Validate.notNull(dao, "A DAO is needed");
		Validate.notNull(queryString, "A query string (sql) is needed");
	}

	/**
	 * @return Returns the queryString.
	 */
	public String getQueryString() {
		return queryString;
	}

	/**
	 * @param queryString
	 *            The queryString to set.
	 */
	public void setQueryString(String queryString) {
		this.queryString = queryString;
	}

	/**
	 * @return Returns the dao.
	 */
	public DAOOperations getDao() {
		return dao;
	}

	/**
	 * @param dao
	 *            The dao to set.
	 */
	public void setDao(DAOOperations dao) {
		this.dao = dao;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med
	 * .fw.batchprocess.DataProcessExecutionContext, java.util.List)
	 */
	protected final void processData(DataProcessExecutionContext context, List acquiredData) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.batchprocess.AbstractDataProcess#acquireData(gov.va.med
	 * .fw.batchprocess.DataProcessExecutionContext)
	 */
	protected final List acquireData(DataProcessExecutionContext context) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
}
