/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.util.List;

import gov.va.med.fw.util.InvalidConfigurationException;

/**
 * Specialization of AbstractDataFileListenerProcess that allows for record
 * processing in fixed increments at a time, rather than the entire List of data
 * at once.
 * 
 * Created Feb 2, 2006 4:15:50 PM
 * 
 * @author VHAISABOHMEG
 */
public abstract class AbstractDataFileIncrementalProcess extends AbstractDataFileListenerProcess {
	private int incrementSize = 25; // default is 25 at a time

	// can be overriden by subclasses
	public boolean acceptData(DataFileProcessExecutionContext context, String nextRowRawData,
			List beans) {
		return beans.size() == incrementSize;
	}

	public void afterPropertiesSet() {
		super.afterPropertiesSet();
		if (incrementSize <= 0)
			throw new InvalidConfigurationException(
					"Invalid incrementSize.  Must be positive number");
	}

	/**
	 * @return Returns the incrementSize.
	 */
	public int getIncrementSize() {
		return incrementSize;
	}

	/**
	 * @param incrementSize
	 *            The incrementSize to set.
	 */
	public void setIncrementSize(int incrementSize) {
		this.incrementSize = incrementSize;
	}

	protected boolean shouldUpdateJobResult(DataFileProcessExecutionContext context) {
		return context.getProcessStatistics().isTotalNumberMod(incrementSize);
	}
}
