package gov.va.med.fw.validators { 
	import mx.utils.StringUtil;
	import mx.validators.Validator;
    import mx.validators.ValidationResult;

	/**
	*	ICN Validation ##########V######
	*/
	
	[ResourceBundle("validators")]
	public class ICNValidator extends CustomValidator {
				
		public static const ICN_REGEXP : RegExp = /^\d{10}V\d{6}$/i;

		
		private var results:Array = null;
		private var invalidError:String = "{fieldLabel} is invalid.";
		
		public function ICNValidator() {
			super();
		}
		
		/**
		*	Override the method to validate multiple e-mail addresses
		*/
		override protected function doValidation(value:Object):Array
		{
			var results:Array = super.doValidation(value);
			
			var val:String = value ? String(value) : "";
			if (results.length > 0 || ((val.length == 0) && !required)) {
				//return results;
		    }
			else if (!Boolean(val.match(ICN_REGEXP))) {
					results.push(new ValidationResult(true, null, null, invalidICNError));
			}			
			return results;
		}
		
		/**
     	 *  Error message when the icn is invalid
     	 *  @default requiredFieldError={fieldLabel} icn is inavlid.
     	 */
		public function get invalidICNError():String {
			return ValidatorUtil.replaceWithLabel(this.invalidError, fieldLabel);
		}
		public function set invalidICNError(invalidICNError:String):void {
			if (invalidICNError != null && invalidICNError.length > 0) {
				this.invalidError=invalidICNError;
			}
		}		
	}
}
