package gov.va.med.fw.validators {
	import mx.validators.PhoneNumberValidator;

	[ResourceBundle("validators")]
	public class CustomPhoneNumberValidator extends PhoneNumberValidator {
		
		public function CustomPhoneNumberValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError={fieldLabel} is required.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/** 
	 	 *  Error message when the value contains invalid characters.
	 	 *
	 	 *  @default invalidCharErrorPNV={fieldLabel} contains invalid characters.
	 	 */
		override public function get invalidCharError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidCharError, fieldLabel);
		}
	
		/** 
	 	 *  Error message when the value has fewer than 10 digits.
	 	 *
	 	 *  @default {fieldLabel} must contain at least 10 digits.
	 	 */
		override public function get wrongLengthError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongLengthError, fieldLabel);
		}
	}
}