package gov.va.med.fw.utils {
	
	import gov.va.med.fw.utils.StringUtils;
	
	import mx.collections.ArrayCollection;
	import mx.formatters.DateFormatter;
	import gov.va.med.fw.model.TermType;
	
	public class FormatUtils {
		
		public function FormatUtils() {}
		
		public static function formatName(firstName:String,middleName:String,lastName:String):String {
			var fullName:String = "";
			if(!StringUtils.isEmpty(lastName)) {
				fullName = fullName + lastName;
				if(!StringUtils.isEmpty(firstName)) {
					fullName = fullName + ", " + firstName;
				}
				if(!StringUtils.isEmpty(middleName)) {
					if(StringUtils.isEmpty(firstName)) {
						fullName = fullName + ", " + middleName;
					} else {
						fullName = fullName + " " + middleName;
					}
				}
			}
			return fullName;
		}
		
		public static function fullName(prefix:String, firstName:String,middleName:String,lastName:String, suffix:String):String {
			var fullName:String = (StringUtils.isEmpty(prefix)) ? "" : prefix + " ";
			if(!StringUtils.isEmpty(lastName)) {
				fullName = fullName + lastName;
				if(!StringUtils.isEmpty(firstName)) {
					fullName = fullName + ", " + firstName;
				}
				if(!StringUtils.isEmpty(middleName)) {
					if(StringUtils.isEmpty(firstName)) {
						fullName = fullName + ", " + middleName;
					} else {
						fullName = fullName + " " + middleName;
					}
				}
			}
			return fullName;
		}
		
		public static function formatDate(dateOfBirth:Date, format:String = "MM/DD/YYYY"):String {
			var date:String = "";
			format = (format != null && format.length > 0) ? format : "MM/DD/YYYY";
			if(dateOfBirth != null) {
				var formatter:DateFormatter = new DateFormatter();
				formatter.formatString = format;
				date = formatter.format(dateOfBirth);
			}
			return date;
		}
		
		public static function decorateSSN(ssn:String): String {
			var decorateSSN:String = ssn;
			if(ssn != null && ssn.length >= 9) {
				decorateSSN = ssn.substring(0,3) + "-" + ssn.substring(3,5) + "-" + ssn.substring(5,9);
			}
			return decorateSSN;
		}
		
		public static function maskSSN(ssn:String): String {
			var decorateSSN:String = ssn;
			if(ssn != null && ssn.length >= 9) {
				decorateSSN = "XXX-XX-" + ssn.substring(5,9);
			}
			return decorateSSN;
		}
		
		public static function formatTermTypeList(selectedList:ArrayCollection):String {
			if (selectedList != null && selectedList.length > 0) {
				var t:TermType = selectedList.getItemAt(0) as TermType;
				var selected:String  = t.label;
				for (var index:int=1; index < selectedList.length; index++) {
					selected = selected + ", " + (selectedList.getItemAt(index) as TermType).label;
				}
				return selected;
			}else {
				return "None";
			}
		}
	}
}